/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.spi;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    @SafeVarargs
    static <K, V> Map<K, V> mergeMap(Map<K, V> ... maps) {
        List nonNullMaps = Arrays.stream(maps).filter(Objects::nonNull).collect(Collectors.toList());
        if (nonNullMaps.size() == 0) {
            return Collections.emptyMap();
        }
        if (nonNullMaps.size() == 1) {
            return (Map)nonNullMaps.get(0);
        }
        int totalCount = nonNullMaps.stream().mapToInt(Map::size).sum();
        LinkedHashMap finalMap = new LinkedHashMap((totalCount * 4 + 2) / 3);
        for (Map map : nonNullMaps) {
            finalMap.putAll(map);
        }
        return finalMap;
    }

    static <K, T, V> Map<K, V> joinMaps(Map<K, T> map1, Map<T, V> map2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>((map1.size() * 4 + 2) / 3);
        for (Map.Entry<K, T> e : map1.entrySet()) {
            V v = map2.get(e.getValue());
            if (v == null) continue;
            map.put(e.getKey(), v);
        }
        return map;
    }

    static <K, T, V> Map<K, List<V>> joinMultiMapAndMap(Map<K, List<T>> map1, Map<T, V> map2) {
        LinkedHashMap map = new LinkedHashMap((map1.size() * 4 + 2) / 3);
        for (Map.Entry<K, List<T>> e : map1.entrySet()) {
            List<T> originalValues = e.getValue();
            if (originalValues == null || originalValues.isEmpty()) continue;
            ArrayList<V> values = new ArrayList<V>();
            for (T t : originalValues) {
                values.add(map2.get(t));
            }
            map.put(e.getKey(), values);
        }
        return map;
    }

    static <K, T, V> Map<K, V> joinCollectionAndMap(Collection<K> list, Function<K, T> middleKeyExtractor, Map<T, V> map, boolean useIdentityMap) {
        AbstractMap resultMap = useIdentityMap ? new IdentityHashMap((list.size() * 4 + 2) / 3) : new LinkedHashMap((list.size() * 4 + 2) / 3);
        for (K k : list) {
            T t = middleKeyExtractor.apply(k);
            V v = map.get(t);
            if (v == null) continue;
            resultMap.put(k, v);
        }
        return resultMap;
    }

    static <K, V> Map<K, V> toMap(Function<V, K> keyExtractor, Collection<V> values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>((values.size() * 4 + 2) / 3);
        for (V value : values) {
            K key = keyExtractor.apply(value);
            map.put(key, value);
        }
        if (map.size() < values.size()) {
            LOGGER.warn("Utils.toMap() meet duplicated keys, original collection: {}", values);
        }
        return map;
    }

    static <K, V> Map<K, List<V>> toMultiMap(Function<V, K> keyExtractor, Collection<V> values) {
        return values.stream().collect(Collectors.groupingBy(keyExtractor, Collectors.toList()));
    }

    static <K, V> List<Tuple2<K, V>> toTuples(K key, Collection<V> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2<K, V>> tuples = new ArrayList<Tuple2<K, V>>(values.size());
        for (V value : values) {
            tuples.add(new Tuple2<K, V>(key, value));
        }
        return tuples;
    }

    static <K, V> Map<K, V> toMap(K key, Collection<V> values) {
        if (values.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>((values.size() * 4 + 2) / 3);
        for (V value : values) {
            map.put(key, value);
        }
        return map;
    }
}

