/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.spi;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.association.spi.Utils;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FilterArgsImpl;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;

public abstract class AbstractDataLoader {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final Fetcher<ImmutableSpi> fetcher;
    private final Filter<Table<ImmutableSpi>> filter;
    private final ImmutableProp thisIdProp;
    private final ImmutableProp targetIdProp;
    private final int limit;
    private final int offset;

    protected AbstractDataLoader(JSqlClient sqlClient, Connection con, ImmutableProp prop, Fetcher<?> fetcher, Filter<?> filter, int limit, int offset) {
        if (!prop.isAssociation()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not association");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.fetcher = fetcher != null ? fetcher : new FetcherImpl(prop.getTargetType().getJavaClass());
        this.filter = filter;
        this.thisIdProp = prop.getDeclaringType().getIdProp();
        this.targetIdProp = prop.getTargetType().getIdProp();
        this.limit = limit;
        this.offset = offset;
    }

    public Map<ImmutableSpi, Object> load(Collection<ImmutableSpi> sources) {
        if (sources.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sources.size() > 1 && (this.limit != Integer.MAX_VALUE || this.offset != 0)) {
            throw new IllegalArgumentException("Pagination data loader does not support batch loading");
        }
        if (this.prop.getStorage() instanceof Column) {
            return this.loadParents(sources);
        }
        if (this.prop.isEntityList()) {
            return this.loadTargetMultiMap(sources);
        }
        return this.loadTargetMap(sources);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParents(Collection<ImmutableSpi> sources) {
        List<Object> missedFkSourceIds;
        Cache fkCache = this.sqlClient.getCaches().getAssociationCache(this.prop);
        if (fkCache == null) {
            return this.loadParentsDirectly(sources);
        }
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        if (this.filter != null) {
            missedFkSourceIds = this.toSourceIds(sources);
        } else {
            missedFkSourceIds = new ArrayList<Object>();
            for (ImmutableSpi source : sources) {
                if (source.__isLoaded(this.prop.getId())) {
                    ImmutableSpi immutableSpi = (ImmutableSpi)source.__get(this.prop.getId());
                    if (immutableSpi == null) continue;
                    fkMap.put(this.toSourceId(source), this.toTargetId(immutableSpi));
                    continue;
                }
                missedFkSourceIds.add(this.toSourceId(source));
            }
        }
        if (!missedFkSourceIds.isEmpty()) {
            Map cachedFkMap = fkCache.getAll(missedFkSourceIds, new CacheEnvironment(this.sqlClient, this.con, this.filter, this::queryForeignKeyMap, false));
            for (Object e : missedFkSourceIds) {
                Object fk = cachedFkMap.get(e);
                if (fk == null) continue;
                fkMap.put(e, fk);
            }
        }
        Map targetMap = Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(fkMap.values()))));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap, true);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParentsDirectly(Collection<ImmutableSpi> sources) {
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        ArrayList<Object> missedFkSourceIds = new ArrayList<Object>();
        for (ImmutableSpi source : sources) {
            if (source.__isLoaded(this.prop.getId())) {
                ImmutableSpi target = (ImmutableSpi)source.__get(this.prop.getId());
                if (target == null) continue;
                fkMap.put(this.toSourceId(source), this.toTargetId(target));
                continue;
            }
            missedFkSourceIds.add(this.toSourceId(source));
        }
        Map map1 = null;
        if (!fkMap.isEmpty()) {
            map1 = this.filter != null ? Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.queryTargets(fkMap.values()))) : Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(fkMap.values())));
        }
        Map map2 = null;
        if (!missedFkSourceIds.isEmpty()) {
            if (this.filter != null || this.fetcher.getFieldMap().size() > 1) {
                map2 = Tuple2.toMap(this.querySourceTargetPairs(missedFkSourceIds));
            } else {
                Map<Object, Object> loadedFkMap = this.queryForeignKeyMap(missedFkSourceIds);
                map2 = new LinkedHashMap((missedFkSourceIds.size() * 4 + 2) / 3);
                for (Object e : missedFkSourceIds) {
                    Object targetId = loadedFkMap.get(e);
                    map2.put(e, this.makeIdOnlyTarget(targetId));
                }
            }
        }
        return Utils.joinCollectionAndMap(sources, this::toTargetId, Utils.mergeMap(map1, map2), true);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMap(Collection<ImmutableSpi> sources) {
        Cache cache = this.sqlClient.getCaches().getAssociationCache(this.prop);
        if (cache == null) {
            return this.loadTargetMapDirectly(sources);
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        Map idMap = cache.getAll(sourceIds, new CacheEnvironment(this.sqlClient, this.con, this.filter, it -> Tuple2.toMap(this.querySourceTargetIdPairs(it)), false));
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(idMap.values())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMaps(idMap, targetMap), true);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap, true);
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMap(Collection<ImmutableSpi> sources) {
        Cache cache = this.sqlClient.getCaches().getAssociationCache(this.prop);
        if (cache == null) {
            return this.loadTargetMultiMapDirectly(sources);
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        Map idMultiMap = cache.getAll(sourceIds, new CacheEnvironment(this.sqlClient, this.con, this.filter, it -> Tuple2.toMultiMap(this.querySourceTargetIdPairs(it)), false));
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(idMultiMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMultiMapAndMap(idMultiMap, targetMap), true);
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMultiMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMultiMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap, true);
    }

    private Map<Object, Object> queryForeignKeyMap(Collection<Object> sourceIds) {
        if (sourceIds.size() == 1) {
            Object sourceId = sourceIds.iterator().next();
            List targetIds = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), (q, source) -> {
                Object pkExpr = source.get(this.thisIdProp.getName());
                Object targetTable = source.join(this.prop.getName());
                Object fkExpr = targetTable.get(this.targetIdProp.getName());
                q.where(new Predicate[]{pkExpr.eq((Object)sourceId)});
                q.where(new Predicate[]{fkExpr.isNotNull()});
                this.applyFilter((MutableQuery)q, (Table<?>)targetTable, sourceIds);
                return q.select(fkExpr);
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toMap(sourceId, targetIds);
        }
        List tuples = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), (q, source) -> {
            Object pkExpr = source.get(this.thisIdProp.getName());
            Object targetTable = source.join(this.prop.getName());
            Object fkExpr = targetTable.get(this.targetIdProp.getName());
            q.where(new Predicate[]{pkExpr.in(sourceIds)});
            q.where(new Predicate[]{fkExpr.isNotNull()});
            this.applyFilter((MutableQuery)q, (Table<?>)targetTable, sourceIds);
            return q.select(pkExpr, fkExpr);
        }).execute(this.con);
        return Tuple2.toMap(tuples);
    }

    private List<Tuple2<Object, Object>> querySourceTargetIdPairs(Collection<Object> sourceIds) {
        if (this.filter == null) {
            boolean useMiddleTable = false;
            Storage storage = this.prop.getStorage();
            if (storage != null) {
                useMiddleTable = storage instanceof MiddleTable;
            } else {
                ImmutableProp mappedBy = this.prop.getMappedBy();
                if (mappedBy != null && mappedBy.getStorage() instanceof MiddleTable) {
                    useMiddleTable = true;
                }
            }
            if (useMiddleTable) {
                if (sourceIds.size() == 1) {
                    Object sourceId = sourceIds.iterator().next();
                    List targetIds = (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), (q, association) -> {
                        Object sourceIdExpr = association.source().get(this.thisIdProp.getName());
                        Object targetIdExpr = association.target().get(this.targetIdProp.getName());
                        q.where(new Predicate[]{sourceIdExpr.eq((Object)sourceId)});
                        return q.select(targetIdExpr);
                    }).limit(this.limit, this.offset).execute(this.con);
                    return Utils.toTuples(sourceId, targetIds);
                }
                return (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), (q, association) -> {
                    Object sourceIdExpr = association.source().get(this.thisIdProp.getName());
                    Object targetIdExpr = association.target().get(this.targetIdProp.getName());
                    q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
                    return q.select(sourceIdExpr, targetIdExpr);
                }).execute(this.con);
            }
        }
        return this.executeTupleQuery(sourceIds, target -> target.get(this.targetIdProp.getName()));
    }

    private List<Tuple2<Object, ImmutableSpi>> querySourceTargetPairs(Collection<Object> sourceIds) {
        return this.executeTupleQuery(sourceIds, target -> target.fetch(this.fetcher));
    }

    private List<ImmutableSpi> queryTargets(Collection<Object> targetIds) {
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), (q, target) -> {
            Object idExpr = target.get(this.targetIdProp.getName());
            q.where(new Predicate[]{idExpr.in(targetIds)});
            this.applyFilter((MutableQuery)q, (Table<?>)target, targetIds);
            return q.select(target.fetch(this.fetcher));
        }).execute(this.con);
    }

    private <R> List<Tuple2<Object, R>> executeTupleQuery(Collection<Object> sourceIds, Function<Table<ImmutableSpi>, Selection<?>> valueExpressionGetter) {
        if (sourceIds.size() == 1) {
            Object sourceId = sourceIds.iterator().next();
            List results = (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), (q, target) -> {
                Object sourceIdExpr = target.inverseJoin(this.prop.getDeclaringType().getJavaClass(), this.prop.getName()).get(this.thisIdProp.getName());
                q.where(new Predicate[]{sourceIdExpr.eq((Object)sourceId)});
                this.applyFilter((MutableQuery)q, (Table<?>)target, sourceIds);
                return q.select((Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toTuples(sourceId, results);
        }
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), (q, target) -> {
            Object sourceIdExpr = target.inverseJoin(this.prop.getDeclaringType().getJavaClass(), this.prop.getName()).get(this.thisIdProp.getName());
            q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
            this.applyFilter((MutableQuery)q, (Table<?>)target, sourceIds);
            return q.select(sourceIdExpr, (Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
        }).execute(this.con);
    }

    private void applyFilter(MutableQuery query, Table<?> table, Collection<Object> keys) {
        if (this.filter != null) {
            this.filter.apply(FilterArgsImpl.of((AbstractMutableQueryImpl)query, table, keys));
        }
    }

    private Object toSourceId(ImmutableSpi source) {
        return source.__get(this.thisIdProp.getId());
    }

    private List<Object> toSourceIds(Collection<ImmutableSpi> sources) {
        return sources.stream().map(this::toSourceId).collect(Collectors.toList());
    }

    private Object toTargetId(ImmutableSpi target) {
        if (target == null) {
            return null;
        }
        return target.__get(this.targetIdProp.getId());
    }

    private List<ImmutableSpi> findTargets(Collection<Object> targetIds) {
        if (this.fetcher.getFieldMap().size() > 1) {
            return this.sqlClient.getEntities().forConnection(this.con).findByIds(this.fetcher, targetIds);
        }
        return this.makeIdOnlyTargets(targetIds);
    }

    private List<ImmutableSpi> makeIdOnlyTargets(Collection<Object> targetIds) {
        return targetIds.stream().map(this::makeIdOnlyTarget).collect(Collectors.toCollection(() -> new ArrayList(targetIds.size())));
    }

    private ImmutableSpi makeIdOnlyTarget(Object id) {
        if (id == null) {
            return null;
        }
        return (ImmutableSpi)Internal.produce((ImmutableType)this.prop.getTargetType(), null, draft -> {
            DraftSpi targetDraft = (DraftSpi)draft;
            targetDraft.__set(this.targetIdProp.getId(), id);
        });
    }
}

