/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.meta;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.util.StaticCache;

public class AssociationType
implements ImmutableType {
    private static final StaticCache<ImmutableProp, AssociationType> CACHE = new StaticCache(AssociationType::new, false);
    private MiddleTable middleTable;
    private final ImmutableProp baseProp;
    private final ImmutableType sourceType;
    private final ImmutableType targetType;
    private final AssociationProp sourceProp;
    private final AssociationProp targetProp;
    private final Map<String, ImmutableProp> props;

    public static AssociationType of(ImmutableProp prop) {
        return (AssociationType)CACHE.get((Object)prop);
    }

    private AssociationType(ImmutableProp baseProp) {
        this.baseProp = baseProp;
        ImmutableProp mappedBy = baseProp.getMappedBy();
        if (mappedBy != null && mappedBy.getStorage() instanceof MiddleTable) {
            this.middleTable = ((MiddleTable)mappedBy.getStorage()).getInverse();
        } else if (baseProp.getStorage() instanceof MiddleTable) {
            this.middleTable = (MiddleTable)baseProp.getStorage();
        }
        if (this.middleTable == null) {
            throw new IllegalArgumentException("\"" + baseProp + "\" is neither association bases on middle table nor inverse association of that");
        }
        this.sourceType = baseProp.getDeclaringType();
        this.targetType = baseProp.getTargetType();
        this.sourceProp = new AssociationProp.Source(this);
        this.targetProp = new AssociationProp.Target(this);
        LinkedHashMap<String, AssociationProp> map = new LinkedHashMap<String, AssociationProp>();
        map.put(this.sourceProp.getName(), this.sourceProp);
        map.put(this.targetProp.getName(), this.targetProp);
        this.props = Collections.unmodifiableMap(map);
    }

    public ImmutableProp getBaseProp() {
        return this.baseProp;
    }

    public MiddleTable getMiddleTable() {
        return this.middleTable;
    }

    public ImmutableType getSourceType() {
        return this.sourceType;
    }

    public ImmutableType getTargetType() {
        return this.targetType;
    }

    public AssociationProp getSourceProp() {
        return this.sourceProp;
    }

    public AssociationProp getTargetProp() {
        return this.targetProp;
    }

    public Class<?> getJavaClass() {
        return Association.class;
    }

    public String getTableName() {
        return this.middleTable.getTableName();
    }

    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.props;
    }

    public Map<String, ImmutableProp> getProps() {
        return this.props;
    }

    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.props.get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + this + "\"");
        }
        return prop;
    }

    public ImmutableProp getPropByColumnName(String columnName) {
        String scName = DatabaseIdentifiers.standardIdentifier((String)columnName);
        if (scName.equals(DatabaseIdentifiers.standardIdentifier((String)((Column)this.sourceProp.getStorage()).getName()))) {
            return this.sourceProp;
        }
        if (scName.equals(DatabaseIdentifiers.standardIdentifier((String)((Column)this.targetProp.getStorage()).getName()))) {
            return this.targetProp;
        }
        throw new IllegalArgumentException("There is no property whose column name is \"" + columnName + "\" in type \"" + this + "\"");
    }

    public Map<String, ImmutableProp> getSelectableProps() {
        return this.props;
    }

    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        throw new UnsupportedOperationException("draftFactory is not supported by AssociationType");
    }

    public ImmutableType getSuperType() {
        return null;
    }

    public ImmutableProp getIdProp() {
        throw new UnsupportedOperationException("Id property is not supported by association type");
    }

    public ImmutableProp getVersionProp() {
        return null;
    }

    public Set<ImmutableProp> getKeyProps() {
        return Collections.emptySet();
    }

    public IdGenerator getIdGenerator() {
        return null;
    }

    public String toString() {
        return "MiddleTable(" + this.baseProp + ")";
    }
}

