/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Converts {
    private Converts() {
    }

    public static Object tryConvert(Object value, Class<?> expectedType) {
        if (value == null || value.getClass() == expectedType) {
            return value;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (expectedType == Boolean.TYPE || expectedType == Boolean.class) {
                return num.intValue() != 0;
            }
            if (expectedType == Byte.TYPE || expectedType == Byte.class) {
                return num.byteValue();
            }
            if (expectedType == Short.TYPE || expectedType == Short.class) {
                return num.shortValue();
            }
            if (expectedType == Integer.TYPE || expectedType == Integer.class) {
                return num.intValue();
            }
            if (expectedType == Long.TYPE || expectedType == Long.class) {
                return num.longValue();
            }
            if (expectedType == Float.TYPE || expectedType == Float.class) {
                return Float.valueOf(num.floatValue());
            }
            if (expectedType == Double.TYPE || expectedType == Double.class) {
                return num.doubleValue();
            }
            if (expectedType == BigInteger.class) {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (expectedType == BigDecimal.class) {
                if (value instanceof BigInteger) {
                    return ((BigInteger)value).toString();
                }
                return BigDecimal.valueOf(num.doubleValue());
            }
        }
        return null;
    }
}

