/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.fetcher.impl.FilterArgsImpl;
import org.babyfish.jimmer.sql.meta.Column;

class SingleDataLoader {
    private final SqlClient sqlClient;
    private final Connection con;
    private final Field field;

    public SingleDataLoader(SqlClient sqlClient, Connection con, Field field) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.field = field;
    }

    public Object load(Object key) {
        ImmutableProp prop = this.field.getProp();
        if (prop.getStorage() instanceof Column) {
            return this.loadParent(key);
        }
        if (prop.isEntityList() && prop.getMappedBy() != null && prop.getMappedBy().isReference()) {
            return this.loadChildren(key);
        }
        if (this.field.getChildFetcher() == null || this.field.getChildFetcher().getFieldMap().size() == 1) {
            return this.loadTargetsWithOnlyId(key);
        }
        return this.loadTargets(key);
    }

    private ImmutableSpi loadParent(Object key) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        List parents = (List)Queries.createQuery(this.sqlClient, prop.getTargetType(), (q, t) -> {
            Table table = t;
            Object pk = table.get(prop.getTargetType().getIdProp().getName());
            q.where(new Predicate[]{pk.eq((Object)key)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.singleLoaderArgs(q, table, key));
            }
            return q.select(table.fetch(this.field.getChildFetcher()));
        }).limit(this.field.getLimit(), this.field.getOffset()).execute(this.con);
        return parents.isEmpty() ? null : (ImmutableSpi)parents.get(0);
    }

    private List<ImmutableSpi> loadChildren(Object key) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        return (List)Queries.createQuery(this.sqlClient, prop.getTargetType(), (q, t) -> {
            Table table = t;
            Object fk = table.join(prop.getMappedBy().getName()).get(prop.getTargetType().getIdProp().getName());
            q.where(new Predicate[]{fk.eq((Object)key)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.singleLoaderArgs(q, table, key));
            }
            return q.select(table.fetch(this.field.getChildFetcher()));
        }).limit(this.field.getLimit(), this.field.getOffset()).execute(this.con);
    }

    private List<ImmutableSpi> loadTargetsWithOnlyId(Object key) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        AssociationType associationType = AssociationType.of(prop);
        List targetIds = (List)Queries.createAssociationQuery(this.sqlClient, associationType, (q, t) -> {
            Object sourceId = t.source().get(prop.getDeclaringType().getIdProp().getName());
            q.where(new Predicate[]{sourceId.eq((Object)key)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.singleLoaderArgs(q, t.target(), key));
            }
            return q.select(t.target().get(prop.getTargetType().getIdProp().getName()));
        }).limit(this.field.getLimit(), this.field.getOffset()).execute(this.con);
        ArrayList<ImmutableSpi> targets = new ArrayList<ImmutableSpi>(targetIds.size());
        String targetIdPropName = prop.getTargetType().getIdProp().getName();
        for (Object targetId : targetIds) {
            targets.add((ImmutableSpi)Internal.produce((ImmutableType)prop.getTargetType(), null, targetDraft -> ((DraftSpi)targetDraft).__set(targetIdPropName, targetId)));
        }
        return targets;
    }

    private List<ImmutableSpi> loadTargets(Object key) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        AssociationType associationType = AssociationType.of(prop);
        return (List)Queries.createAssociationQuery(this.sqlClient, associationType, (q, t) -> {
            Object sourceId = t.source().get(prop.getDeclaringType().getIdProp().getName());
            q.where(new Predicate[]{sourceId.eq((Object)key)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.singleLoaderArgs(q, t.target(), key));
            }
            return q.select(t.target().fetch(this.field.getChildFetcher()));
        }).limit(this.field.getLimit(), this.field.getOffset()).execute(this.con);
    }
}

