/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.BatchDataLoader;
import org.babyfish.jimmer.sql.fetcher.impl.DataCache;
import org.babyfish.jimmer.sql.fetcher.impl.SingleDataLoader;

class FetcherTask {
    private final DataCache cache;
    private final SqlClient sqlClient;
    private Field field;
    private final int batchSize;
    private final SingleDataLoader singleDataLoader;
    private final BatchDataLoader batchDataLoader;
    private Map<Object, TaskData> pendingMap = new LinkedHashMap<Object, TaskData>();

    public FetcherTask(DataCache cache, SqlClient sqlClient, Connection con, Field field) {
        this.cache = cache;
        this.sqlClient = sqlClient;
        this.field = field;
        this.batchSize = this.determineBatchSize();
        this.singleDataLoader = new SingleDataLoader(sqlClient, con, field);
        this.batchDataLoader = new BatchDataLoader(sqlClient, con, field);
    }

    public void add(DraftSpi draft) {
        this.add(draft, 1);
    }

    private void add(DraftSpi draft, int depth) {
        if (this.isLoaded(draft)) {
            return;
        }
        Object key = this.cache.createKey(this.field, (ImmutableSpi)draft);
        if (key == null) {
            return;
        }
        Object value = this.cache.get(this.field, key);
        if (value != null) {
            this.setDraftProp(draft, DataCache.unwrap(value));
            return;
        }
        this.pendingMap.computeIfAbsent(key, it -> new TaskData(depth)).getDrafts().add(draft);
    }

    public boolean execute() {
        Map<Object, TaskData> handledMap;
        Map.Entry<Object, TaskData> e;
        if (this.pendingMap.isEmpty()) {
            return true;
        }
        if (this.pendingMap.size() > this.batchSize) {
            Iterator<Map.Entry<Object, TaskData>> itr = this.pendingMap.entrySet().iterator();
            if (this.batchSize == 1) {
                e = itr.next();
                handledMap = Collections.singletonMap(e.getKey(), e.getValue());
                itr.remove();
            } else {
                handledMap = new LinkedHashMap<Object, TaskData>((this.batchSize * 4 + 2) / 3);
                for (int i = this.batchSize; i > 0; --i) {
                    Map.Entry<Object, TaskData> e2 = itr.next();
                    handledMap.put(e2.getKey(), e2.getValue());
                    itr.remove();
                }
            }
        } else {
            handledMap = this.pendingMap;
            this.pendingMap = new LinkedHashMap<Object, TaskData>();
        }
        Iterator<Map.Entry<Object, TaskData>> handledEntryItr = handledMap.entrySet().iterator();
        while (handledEntryItr.hasNext()) {
            e = handledEntryItr.next();
            Object key = e.getKey();
            Object value = this.cache.get(this.field, key);
            if (value == null) continue;
            value = DataCache.unwrap(value);
            TaskData taskData = e.getValue();
            this.afterLoad(key, value, taskData, false);
            handledEntryItr.remove();
        }
        if (!handledMap.isEmpty()) {
            if (this.batchSize == 1) {
                Object key = handledMap.keySet().iterator().next();
                Object value = this.singleDataLoader.load(key);
                TaskData taskData = handledMap.get(key);
                this.afterLoad(key, value, taskData, true);
            } else {
                Map<Object, ?> loadedMap = this.batchDataLoader.load(handledMap.keySet());
                for (Map.Entry<Object, TaskData> e3 : handledMap.entrySet()) {
                    Object key = e3.getKey();
                    Object value = loadedMap.get(key);
                    TaskData taskData = e3.getValue();
                    this.afterLoad(key, value, taskData, true);
                }
            }
        }
        return this.pendingMap.isEmpty();
    }

    private boolean isLoaded(DraftSpi draft) {
        if (!FetcherTask.isLoaded(draft, this.field)) {
            return false;
        }
        Fetcher<?> childFetcher = this.field.getChildFetcher();
        Object childValue = draft.__get(this.field.getProp().getName());
        if (childFetcher != null && childValue != null) {
            for (Field childField : childFetcher.getFieldMap().values()) {
                if (FetcherTask.isLoaded(childValue, childField)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isLoaded(Object obj, Field field) {
        if (obj instanceof List) {
            List drafts = (List)obj;
            for (DraftSpi draft : drafts) {
                if (FetcherTask.isLoaded(draft, field)) continue;
                return false;
            }
            return true;
        }
        return ((DraftSpi)obj).__isLoaded(field.getProp().getName());
    }

    private void afterLoad(Object key, Object value, TaskData taskData, boolean updateCache) {
        if (updateCache) {
            this.cache.put(this.field, key, value);
        }
        for (DraftSpi draft : taskData.getDrafts()) {
            this.setDraftProp(draft, value);
        }
        RecursionStrategy<?> recursionStrategy = this.field.getRecursionStrategy();
        if (value instanceof List) {
            List targets = (List)value;
            for (ImmutableSpi target : targets) {
                DraftContext draftContext = Internal.currentDraftContext();
                if (recursionStrategy == null || !recursionStrategy.isFetchable(target, taskData.depth)) continue;
                this.add((DraftSpi)draftContext.toDraftObject((Object)target), taskData.getDepth() + 1);
            }
        } else if (value != null && recursionStrategy != null && recursionStrategy.isFetchable(value, taskData.depth)) {
            DraftContext draftContext = Internal.currentDraftContext();
            this.add((DraftSpi)draftContext.toDraftObject(value), taskData.getDepth() + 1);
        }
    }

    private int determineBatchSize() {
        if (this.field.getLimit() != Integer.MAX_VALUE) {
            return 1;
        }
        int size = this.field.getBatchSize();
        if (size == 0) {
            if (this.field.getProp().isEntityList()) {
                return this.sqlClient.getDefaultListBatchSize();
            }
            return this.sqlClient.getDefaultBatchSize();
        }
        return size;
    }

    private void setDraftProp(DraftSpi draft, Object value) {
        if (value == null && this.field.getProp().isEntityList()) {
            draft.__set(this.field.getProp().getName(), Collections.emptyList());
        } else {
            draft.__set(this.field.getProp().getName(), value);
        }
    }

    private static class TaskData {
        private int depth;
        private Collection<DraftSpi> drafts = new ArrayList<DraftSpi>();

        public TaskData(int depth) {
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public Collection<DraftSpi> getDrafts() {
            return this.drafts;
        }

        public String toString() {
            return "TaskData{depth=" + this.depth + ", drafts=" + this.drafts + '}';
        }
    }
}

