/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.fetcher.impl.FilterArgsImpl;
import org.babyfish.jimmer.sql.meta.Column;

class BatchDataLoader {
    private final SqlClient sqlClient;
    private final Connection con;
    private final Field field;

    public BatchDataLoader(SqlClient sqlClient, Connection con, Field field) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.field = field;
    }

    public Map<Object, ?> load(Collection<Object> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableProp prop = this.field.getProp();
        if (prop.getStorage() instanceof Column) {
            return this.loadParents(keys);
        }
        if (prop.isEntityList() && prop.getMappedBy() != null && prop.getMappedBy().isReference()) {
            return this.loadChildren(keys);
        }
        if (this.field.getChildFetcher() == null || this.field.getChildFetcher().getFieldMap().size() == 1) {
            return this.loadTargetsWithOnlyId(keys);
        }
        return this.loadTargets(keys);
    }

    private Map<Object, ImmutableSpi> loadParents(Collection<Object> keys) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        List parents = (List)Queries.createQuery(this.sqlClient, prop.getTargetType(), (q, t) -> {
            Table table = t;
            Object pk = table.get(prop.getTargetType().getIdProp().getName());
            q.where(new Predicate[]{pk.in(keys)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.batchLoaderArgs(q, table, keys));
            }
            return q.select(table.fetch(this.field.getChildFetcher()));
        }).execute(this.con);
        HashMap<Object, ImmutableSpi> parentMap = new HashMap<Object, ImmutableSpi>((parents.size() * 4 + 2) / 3);
        String parentIdPropName = prop.getTargetType().getIdProp().getName();
        for (ImmutableSpi parent : parents) {
            parentMap.put(parent.__get(parentIdPropName), parent);
        }
        return parentMap;
    }

    private Map<Object, List<ImmutableSpi>> loadChildren(Collection<Object> keys) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        List tuples = (List)Queries.createQuery(this.sqlClient, prop.getTargetType(), (q, t) -> {
            Table table = t;
            Object fk = table.join(prop.getMappedBy().getName()).get(prop.getTargetType().getIdProp().getName());
            q.where(new Predicate[]{fk.in(keys)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.batchLoaderArgs(q, table, keys));
            }
            return q.select(fk, table.fetch(this.field.getChildFetcher()));
        }).execute(this.con);
        return Tuple2.toMultiMap(tuples);
    }

    private Map<Object, List<ImmutableSpi>> loadTargetsWithOnlyId(Collection<Object> keys) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        AssociationType associationType = AssociationType.of(prop);
        List tuples = (List)Queries.createAssociationQuery(this.sqlClient, associationType, (q, t) -> {
            Object sourceId = t.source().get(prop.getDeclaringType().getIdProp().getName());
            q.where(new Predicate[]{sourceId.in(keys)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.batchLoaderArgs(q, t.target(), keys));
            }
            return q.select(sourceId, t.target().get(prop.getTargetType().getIdProp().getName()));
        }).execute(this.con);
        HashMap<Object, List<ImmutableSpi>> targetMap = new HashMap<Object, List<ImmutableSpi>>();
        String targetIdPropName = prop.getTargetType().getIdProp().getName();
        for (Tuple2 tuple : tuples) {
            targetMap.computeIfAbsent(tuple._1(), it -> new ArrayList()).add((ImmutableSpi)Internal.produce((ImmutableType)prop.getTargetType(), null, targetDraft -> ((DraftSpi)targetDraft).__set(targetIdPropName, tuple._2())));
        }
        return targetMap;
    }

    private Map<Object, List<ImmutableSpi>> loadTargets(Collection<Object> keys) {
        ImmutableProp prop = this.field.getProp();
        Filter<?, ?> filter = this.field.getFilter();
        AssociationType associationType = AssociationType.of(prop);
        List tuples = (List)Queries.createAssociationQuery(this.sqlClient, associationType, (q, t) -> {
            Object sourceId = t.source().get(prop.getDeclaringType().getIdProp().getName());
            q.where(new Predicate[]{sourceId.in(keys)});
            if (filter != null) {
                filter.apply(FilterArgsImpl.batchLoaderArgs(q, t.target(), keys));
            }
            return q.select(sourceId, t.target().fetch(this.field.getChildFetcher()));
        }).execute(this.con);
        return Tuple2.toMultiMap(tuples);
    }
}

