/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.criteria.JoinType;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.impl.table.TableWrappers;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class TableImpl<E>
implements TableImplementor<E> {
    private AbstractMutableStatementImpl statement;
    private ImmutableType immutableType;
    private TableImpl<?> parent;
    private boolean isInverse;
    private ImmutableProp joinProp;
    private JoinType joinType;
    private String alias;
    private String middleTableAlias;
    private Map<String, TableImpl<?>> childTableMap = new HashMap();

    public TableImpl(AbstractMutableStatementImpl statement, ImmutableType immutableType, TableImpl<?> parent, boolean isInverse, ImmutableProp joinProp, JoinType joinType) {
        if (parent != null && immutableType instanceof AssociationType) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent == null != (joinProp == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        this.statement = statement;
        this.immutableType = immutableType;
        this.parent = parent;
        this.isInverse = isInverse;
        this.joinProp = joinProp;
        this.joinType = joinType;
        if (joinProp != null) {
            if (joinProp.getStorage() instanceof MiddleTable) {
                this.middleTableAlias = statement.getTableAliasAllocator().allocate();
            } else if (joinProp.getStorage() == null) {
                throw new AssertionError((Object)"Internal bug: Join property has not storage");
            }
        }
        this.alias = statement.getTableAliasAllocator().allocate();
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.statement;
    }

    @Override
    public TableImplementor<?> getParent() {
        return this.parent;
    }

    @Override
    public Collection<TableImplementor<?>> getChildren() {
        return Collections.unmodifiableCollection(this.childTableMap.values());
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public ImmutableProp getJoinProp() {
        return this.joinProp;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (TableImplementor.unwrap(other).getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).eq(other.get(idPropName));
    }

    @Override
    public Predicate isNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        return this.get(this.immutableType.getIdProp().getName()).count(distinct);
    }

    @Override
    public <XE extends Expression<?>> XE get(String prop) {
        ImmutableProp immutableProp = (ImmutableProp)this.immutableType.getProps().get(prop);
        if (immutableProp == null || !immutableProp.isScalar()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not scalar property of \"" + this.immutableType + "\"");
        }
        return (XE)PropExpressionImpl.of(this, immutableProp);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        return this.join(prop, JoinType.INNER);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        ImmutableProp immutableProp = (ImmutableProp)this.immutableType.getProps().get(prop);
        if (immutableProp == null || !immutableProp.isAssociation()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not association property of \"" + this.immutableType + "\"");
        }
        return (XT)this.join0(false, immutableProp, joinType);
    }

    @Override
    public <XE, XT extends Table<XE>> XT inverseJoin(Class<XE> targetType, String backProp) {
        return this.inverseJoin(targetType, backProp, JoinType.INNER);
    }

    @Override
    public <XE, XT extends Table<XE>> XT inverseJoin(Class<XE> targetType, String backProp, JoinType joinType) {
        ImmutableType immutableTargetType = ImmutableType.tryGet(targetType);
        if (immutableTargetType == null) {
            throw new IllegalArgumentException("'" + targetType.getName() + "' is not entity type");
        }
        ImmutableProp immutableBackProp = (ImmutableProp)immutableTargetType.getProps().get(backProp);
        if (immutableBackProp == null || immutableBackProp.getTargetType() != this.immutableType) {
            throw new IllegalArgumentException("'" + backProp + "' is not back association property");
        }
        return (XT)this.join0(true, immutableBackProp, joinType);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoinByTable(Class<XT> targetTableType, String backProp) {
        return this.inverseJoinByTable(targetTableType, backProp, this.joinType);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoinByTable(Class<XT> targetTableType, String backProp, JoinType joinType) {
        ImmutableType immutableType = ImmutableType.tryGet(targetTableType);
        if (immutableType == null) {
            throw new IllegalArgumentException("Cannot get immutable type from table type \"" + targetTableType.getName() + "\"");
        }
        return this.inverseJoin(immutableType.getJavaClass(), backProp, joinType);
    }

    private Table<?> join0(boolean isInverse, ImmutableProp prop, JoinType joinType) {
        if (prop.isTransient()) {
            throw new ExecutionException("Cannot join to '" + prop.getName() + "' because it's transient association");
        }
        if (isInverse && prop instanceof AssociationProp) {
            throw new ExecutionException("Cannot join to '" + prop + "' by inverse mode because it's property of association entity");
        }
        this.statement.validateMutable();
        String joinName = !isInverse ? prop.getName() : (prop.getOpposite() != null ? prop.getOpposite().getName() : "inverse(" + prop + ")");
        if (prop.getMappedBy() != null) {
            return this.join1(joinName, !isInverse, prop.getMappedBy(), joinType);
        }
        return this.join1(joinName, isInverse, prop, joinType);
    }

    private Table<?> join1(String joinName, boolean isInverse, ImmutableProp prop, JoinType joinType) {
        TableImpl<?> existing = this.childTableMap.get(joinName);
        if (existing != null) {
            if (existing.joinType != joinType) {
                existing.joinType = JoinType.INNER;
            }
            return TableWrappers.wrap(existing);
        }
        TableImpl<E> newTable = new TableImpl<E>(this.statement, isInverse ? prop.getDeclaringType() : prop.getTargetType(), this, isInverse, prop, joinType);
        this.childTableMap.put(joinName, newTable);
        return TableWrappers.wrap(newTable);
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this;
        }
        if (fetcher.isSimpleFetcher() && fetcher.getFieldMap().keySet().equals(this.immutableType.getSelectableProps().keySet())) {
            return this;
        }
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, current table is \"" + this + "\" but the fetcher type is \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public void accept(AstVisitor visitor) {
        visitor.visitTableReference(this, null);
    }

    @Override
    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (this.parent == null) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom can only be called base on joined tables");
        }
        if (mode == TableImplementor.RenderMode.NORMAL) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom does not accept render mode ALL");
        }
        if (builder.isTableUsed(this)) {
            this.renderSelf(builder, mode);
            if (mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY) {
                for (TableImpl<?> childTable : this.childTableMap.values()) {
                    childTable.renderTo(builder);
                }
            }
        }
    }

    @Override
    public void renderTo(SqlBuilder builder) {
        this.renderSelf(builder, TableImplementor.RenderMode.NORMAL);
        if (this.parent == null || builder.isTableUsed(this)) {
            for (TableImpl<?> childTable : this.childTableMap.values()) {
                childTable.renderTo(builder);
            }
        }
    }

    private void renderSelf(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        if (this.isInverse) {
            this.renderInverseJoin(sqlBuilder, mode);
        } else if (this.joinProp != null) {
            this.renderJoin(sqlBuilder, mode);
        } else {
            sqlBuilder.sql(" from ").sql(this.immutableType.getTableName()).sql(" as ").sql(this.alias);
        }
    }

    private void renderJoin(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (this.joinProp instanceof AssociationProp) {
            if (builder.isTableUsed(this)) {
                this.renderJoinImpl(builder, this.joinType, this.parent.alias, ((Column)this.joinProp.getStorage()).getName(), this.immutableType.getTableName(), this.alias, ((Column)this.immutableType.getIdProp().getStorage()).getName(), mode);
            }
            return;
        }
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        MiddleTable middleTable = null;
        if (this.joinProp.getStorage() instanceof MiddleTable) {
            middleTable = (MiddleTable)this.joinProp.getStorage();
        }
        if (middleTable != null) {
            this.renderJoinImpl(builder, joinType, parent.alias, ((Column)parent.immutableType.getIdProp().getStorage()).getName(), middleTable.getTableName(), this.middleTableAlias, middleTable.getJoinColumnName(), mode);
            if (builder.isTableUsed(this) && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(builder, joinType, this.middleTableAlias, middleTable.getTargetJoinColumnName(), this.immutableType.getTableName(), this.alias, ((Column)this.immutableType.getIdProp().getStorage()).getName(), TableImplementor.RenderMode.NORMAL);
            }
        } else if (builder.isTableUsed(this)) {
            this.renderJoinImpl(builder, joinType, parent.alias, ((Column)this.joinProp.getStorage()).getName(), this.immutableType.getTableName(), this.alias, ((Column)parent.immutableType.getIdProp().getStorage()).getName(), mode);
        }
    }

    private void renderInverseJoin(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        MiddleTable middleTable = null;
        if (this.joinProp.getStorage() instanceof MiddleTable) {
            middleTable = (MiddleTable)this.joinProp.getStorage();
        }
        if (middleTable != null) {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, ((Column)parent.immutableType.getIdProp().getStorage()).getName(), middleTable.getTableName(), this.middleTableAlias, middleTable.getTargetJoinColumnName(), mode);
            if (sqlBuilder.isTableUsed(this) && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(sqlBuilder, joinType, this.middleTableAlias, middleTable.getJoinColumnName(), this.immutableType.getTableName(), this.alias, ((Column)this.immutableType.getIdProp().getStorage()).getName(), TableImplementor.RenderMode.NORMAL);
            }
        } else {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, ((Column)parent.immutableType.getIdProp().getStorage()).getName(), this.immutableType.getTableName(), this.alias, ((Column)this.joinProp.getStorage()).getName(), mode);
        }
    }

    private void renderJoinImpl(SqlBuilder sqlBuilder, JoinType joinType, String previousAlias, String previousColumnName, String newTableName, String newAlias, String newColumnName, TableImplementor.RenderMode mode) {
        if (mode != TableImplementor.RenderMode.NORMAL && joinType != JoinType.INNER) {
            throw new AssertionError((Object)"Internal bug: outer join cannot be accepted by abnormal render mode");
        }
        switch (mode) {
            case NORMAL: {
                sqlBuilder.sql(" ").sql(joinType.name().toLowerCase()).sql(" join ").sql(newTableName).sql(" as ").sql(newAlias).sql(" on ");
                break;
            }
            case FROM_ONLY: {
                sqlBuilder.sql(newTableName).sql(" as ").sql(newAlias);
            }
        }
        if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
            sqlBuilder.sql(previousAlias).sql(".").sql(previousColumnName).sql(" = ").sql(newAlias).sql(".").sql(newColumnName);
        }
    }

    @Override
    public void renderSelection(ImmutableProp prop, SqlBuilder builder) {
        if (prop.isId() && this.joinProp != null) {
            MiddleTable middleTable = this.joinProp.getStorage() instanceof MiddleTable ? (MiddleTable)this.joinProp.getStorage() : null;
            boolean isInverse = this.isInverse;
            if (middleTable != null) {
                builder.sql(this.middleTableAlias).sql(".");
                if (isInverse) {
                    builder.sql(middleTable.getJoinColumnName());
                } else {
                    builder.sql(middleTable.getTargetJoinColumnName());
                }
                return;
            }
            if (!isInverse) {
                builder.sql(this.parent.alias).sql(".").sql(((Column)this.joinProp.getStorage()).getName());
                return;
            }
        }
        builder.sql(this.alias).sql(".").sql(((Column)prop.getStorage()).getName());
    }

    public String toString() {
        String text;
        if (this.joinProp == null) {
            text = this.immutableType.getJavaClass().getSimpleName();
        } else if (this.isInverse) {
            ImmutableProp opposite = this.joinProp.getOpposite();
            text = opposite != null ? this.parent.toString() + '.' + opposite.getName() : "\u2190 " + this.parent + '.' + this.joinProp.getName();
        } else {
            return this.parent.toString() + '.' + this.joinProp.getName();
        }
        if (this.joinType == JoinType.INNER) {
            return text;
        }
        return text + '(' + this.joinType.name().toLowerCase() + ')';
    }

    @Override
    public TableRowCountDestructive getDestructive() {
        ImmutableProp prop;
        if (this.joinProp == null) {
            return TableRowCountDestructive.NONE;
        }
        if (this.isInverse) {
            prop = this.joinProp.getOpposite();
            if (prop == null) {
                return TableRowCountDestructive.BREAK_REPEATABILITY;
            }
        } else {
            prop = this.joinProp;
        }
        if (prop.isEntityList()) {
            return TableRowCountDestructive.BREAK_REPEATABILITY;
        }
        if (prop.isNullable() && this.joinType != JoinType.LEFT) {
            return TableRowCountDestructive.BREAK_ROW_COUNT;
        }
        return TableRowCountDestructive.NONE;
    }
}

