/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedTypedRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.query.ConfigurableTypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class ConfigurableTypedRootQueryImpl<T extends Table<?>, R>
extends AbstractConfigurableTypedQueryImpl<R>
implements ConfigurableTypedRootQuery<T, R> {
    public ConfigurableTypedRootQueryImpl(TypedQueryData data, MutableRootQueryImpl<T> baseQuery) {
        super(data, baseQuery);
    }

    @Override
    public MutableRootQueryImpl<T> getBaseQuery() {
        return (MutableRootQueryImpl)super.getBaseQuery();
    }

    @Override
    public <X> ConfigurableTypedRootQuery<T, X> reselect(BiFunction<MutableRootQuery<T>, T, ConfigurableTypedRootQuery<T, X>> block) {
        if (this.getData().getOldSelections() != null) {
            throw new IllegalStateException("The current query has been reselected, it cannot be reselect again");
        }
        if (this.getBaseQuery().isGroupByClauseUsed()) {
            throw new IllegalStateException("The current query uses group by clause, it cannot be reselected");
        }
        ReselectValidator visitor = new ReselectValidator();
        for (Selection<?> selection : this.getData().getSelections()) {
            if (selection instanceof Table) {
                TableImplementor.unwrap((Table)selection).accept(visitor);
                continue;
            }
            ((Ast)((Object)selection)).accept(visitor);
        }
        ConfigurableTypedRootQuery<T, X> reselected = block.apply((MutableRootQuery<AbstractMutableQueryImpl>)((Object)this.getBaseQuery()), (AbstractMutableQueryImpl)((Object)this.getBaseQuery().getTable()));
        List<Selection<?>> selections = ((ConfigurableTypedRootQueryImpl)reselected).getData().getSelections();
        return new ConfigurableTypedRootQueryImpl<T, R>(this.getData().reselect(selections), this.getBaseQuery());
    }

    @Override
    public ConfigurableTypedRootQuery<T, R> distinct() {
        TypedQueryData data = this.getData();
        if (data.isDistinct()) {
            return this;
        }
        return new ConfigurableTypedRootQueryImpl<T, R>(data.distinct(), this.getBaseQuery());
    }

    @Override
    public ConfigurableTypedRootQuery<T, R> limit(int limit, int offset) {
        TypedQueryData data = this.getData();
        if (data.getLimit() == limit && data.getOffset() == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        if (limit > Integer.MAX_VALUE - offset) {
            throw new IllegalArgumentException("'limit' > Int.MAX_VALUE - offset");
        }
        return new ConfigurableTypedRootQueryImpl<T, R>(data.limit(limit, offset), this.getBaseQuery());
    }

    @Override
    public ConfigurableTypedRootQuery<T, R> withoutSortingAndPaging() {
        TypedQueryData data = this.getData();
        if (data.isWithoutSortingAndPaging()) {
            return this;
        }
        return new ConfigurableTypedRootQueryImpl<T, R>(data.withoutSortingAndPaging(), this.getBaseQuery());
    }

    @Override
    public ConfigurableTypedRootQuery<T, R> forUpdate() {
        TypedQueryData data = this.getData();
        if (data.isForUpdate()) {
            return this;
        }
        return new ConfigurableTypedRootQueryImpl<T, R>(data.forUpdate(), this.getBaseQuery());
    }

    @Override
    public List<R> execute(Connection con) {
        TypedQueryData data = this.getData();
        if (this.getData().getLimit() == 0) {
            return Collections.emptyList();
        }
        SqlClient sqlClient = this.getBaseQuery().getSqlClient();
        Tuple2<String, List<Object>> sqlResult = this.preExecute(new SqlBuilder(sqlClient));
        return Selectors.select(sqlClient, con, sqlResult._1(), sqlResult._2(), data.getSelections());
    }

    private Tuple2<String, List<Object>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder);
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "intersect", this, other);
    }

    private static class ReselectValidator
    extends AstVisitor {
        ReselectValidator() {
            super(null);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitAggregation(String functionName, Expression<?> expression, String prefix) {
            throw new IllegalStateException("The current query uses aggregation function in select clause, it cannot be reselected");
        }
    }
}

