/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableAliasAllocator;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.impl.table.TableWrappers;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public abstract class AbstractMutableQueryImpl
extends AbstractMutableStatementImpl
implements MutableQuery {
    private Table<?> table;
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private List<Expression<?>> groupByExpressions = new ArrayList();
    private List<Predicate> havingPredicates = new ArrayList<Predicate>();
    private List<Order> orders = new ArrayList<Order>();

    protected AbstractMutableQueryImpl(TableAliasAllocator tableAliasAllocator, SqlClient sqlClient, ImmutableType immutableType) {
        super(tableAliasAllocator, sqlClient);
        this.table = TableWrappers.wrap(TableImplementor.create(this, immutableType));
    }

    @Override
    public AbstractMutableQueryImpl where(Predicate ... predicates) {
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            this.predicates.add(predicate);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl groupBy(Expression<?> ... expressions) {
        for (Expression<?> expression : expressions) {
            if (expression == null) continue;
            this.groupByExpressions.add(expression);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl having(Predicate ... predicates) {
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            this.havingPredicates.add(predicate);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl orderBy(Expression<?> expression) {
        return (AbstractMutableQueryImpl)MutableQuery.super.orderBy((Expression)expression);
    }

    @Override
    public AbstractMutableQueryImpl orderBy(Expression<?> expression, OrderMode orderMode) {
        return (AbstractMutableQueryImpl)MutableQuery.super.orderBy((Expression)expression, orderMode);
    }

    @Override
    public AbstractMutableQueryImpl orderBy(Expression<?> expression, OrderMode orderMode, NullOrderMode nullOrderMode) {
        this.orders.add(new Order(expression, orderMode, nullOrderMode));
        return this;
    }

    public Table<?> getTable() {
        return this.table;
    }

    public List<Predicate> getPredicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    void accept(AstVisitor visitor, List<Selection<?>> overriddenSelections, boolean withoutSortingAndPaging) {
        Object ignoredVisitor;
        if (this.groupByExpressions.isEmpty() && !this.havingPredicates.isEmpty()) {
            throw new IllegalStateException("Having clause cannot be used without group clause");
        }
        for (Predicate predicate : this.predicates) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
        for (Expression<Boolean> expression : this.groupByExpressions) {
            ((Ast)((Object)expression)).accept(visitor);
        }
        for (Predicate predicate : this.havingPredicates) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
        if (withoutSortingAndPaging) {
            ignoredVisitor = new UseJoinOfIgnoredClauseVisitor(visitor.getSqlBuilder());
            for (Order order : this.orders) {
                ((Ast)((Object)order.expression)).accept((AstVisitor)ignoredVisitor);
            }
        } else {
            for (Order order : this.orders) {
                ((Ast)((Object)order.expression)).accept(visitor);
            }
        }
        if (overriddenSelections != null) {
            ignoredVisitor = new UseJoinOfIgnoredClauseVisitor(visitor.getSqlBuilder());
            for (Selection<?> selection : overriddenSelections) {
                Ast.from(selection).accept((AstVisitor)ignoredVisitor);
            }
        }
    }

    void renderTo(SqlBuilder sqlBuilder, boolean withoutSortingAndPaging) {
        String separator;
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        table.renderTo(sqlBuilder);
        if (!this.predicates.isEmpty()) {
            separator = " where ";
            for (Predicate predicate : this.predicates) {
                sqlBuilder.sql(separator);
                ((Ast)((Object)predicate)).renderTo(sqlBuilder);
                separator = " and ";
            }
        }
        if (!this.groupByExpressions.isEmpty()) {
            separator = " group by ";
            for (Expression<Boolean> expression : this.groupByExpressions) {
                sqlBuilder.sql(separator);
                ((Ast)((Object)expression)).renderTo(sqlBuilder);
                separator = ", ";
            }
        }
        if (!this.havingPredicates.isEmpty()) {
            separator = " having ";
            for (Predicate predicate : this.havingPredicates) {
                sqlBuilder.sql(separator);
                ((Ast)((Object)predicate)).renderTo(sqlBuilder);
                separator = " and ";
            }
        }
        if (!withoutSortingAndPaging && !this.orders.isEmpty()) {
            separator = " order by ";
            for (Order order : this.orders) {
                sqlBuilder.sql(separator);
                ((Ast)((Object)order.expression)).renderTo(sqlBuilder);
                if (order.orderMode == OrderMode.ASC) {
                    sqlBuilder.sql(" asc");
                } else {
                    sqlBuilder.sql(" desc");
                }
                if (order.nullOrderMode == NullOrderMode.NULLS_FIRST) {
                    sqlBuilder.sql(" nulls first");
                } else if (order.nullOrderMode == NullOrderMode.NULLS_LAST) {
                    sqlBuilder.sql(" nulls last");
                }
                separator = ", ";
            }
        }
    }

    protected boolean isGroupByClauseUsed() {
        return !this.groupByExpressions.isEmpty();
    }

    private static class Order {
        Expression<?> expression;
        OrderMode orderMode;
        NullOrderMode nullOrderMode;

        public Order(Expression<?> expression, OrderMode orderMode, NullOrderMode nullOrderMode) {
            this.expression = expression;
            this.orderMode = orderMode;
            this.nullOrderMode = nullOrderMode;
        }
    }

    private static class UseJoinOfIgnoredClauseVisitor
    extends AstVisitor {
        public UseJoinOfIgnoredClauseVisitor(SqlBuilder sqlBuilder) {
            super(sqlBuilder);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitTableReference(Table<?> table, ImmutableProp prop) {
            this.handle(TableImplementor.unwrap(table), prop != null && prop.isId());
        }

        private void handle(TableImplementor<?> table, boolean isId) {
            if (table.getDestructive() != TableRowCountDestructive.NONE) {
                if (isId) {
                    this.use(table.getParent());
                } else {
                    this.use(table);
                }
            }
        }

        private void use(TableImplementor<?> table) {
            if (table != null) {
                this.getSqlBuilder().useTable(table);
                this.use(table.getParent());
            }
        }
    }
}

