/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractSaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdAndKeyFetchers;
import org.babyfish.jimmer.sql.ast.impl.mutation.ImmutableCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SequenceIdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.runtime.Converts;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class Saver {
    private AbstractSaveCommandImpl.Data data;
    private Connection con;
    private ImmutableCache cache;
    private Map<AffectedTable, Integer> affectedRowCountMap;
    private String path;

    Saver(AbstractSaveCommandImpl.Data data, Connection con) {
        this(data, con, new ImmutableCache(data), new LinkedHashMap<AffectedTable, Integer>());
    }

    Saver(AbstractSaveCommandImpl.Data data, Connection con, ImmutableCache cache, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.con = con;
        this.cache = cache;
        this.affectedRowCountMap = affectedRowCountMap;
        this.path = "<root>";
    }

    Saver(Saver base, AbstractSaveCommandImpl.Data data, String subPath) {
        this.data = data;
        this.con = base.con;
        this.cache = base.cache;
        this.affectedRowCountMap = base.affectedRowCountMap;
        this.path = base.path + '.' + subPath;
    }

    public <E> SimpleSaveResult<E> save(E entity) {
        ImmutableType immutableType = ImmutableType.get(entity.getClass());
        Object newEntity = Internal.produce((ImmutableType)immutableType, entity, draft -> this.saveImpl((DraftSpi)draft));
        return new SimpleSaveResult<Object>(this.affectedRowCountMap, entity, newEntity);
    }

    private void saveImpl(DraftSpi draftSpi) {
        this.saveAssociations(draftSpi, ObjectType.EXISTING, true);
        ObjectType objectType = this.saveSelf(draftSpi);
        this.saveAssociations(draftSpi, objectType, false);
    }

    private void saveAssociations(DraftSpi currentDraftSpi, ObjectType currentObjectType, boolean forParent) {
        for (ImmutableProp prop : currentDraftSpi.__type().getProps().values()) {
            if (!prop.isAssociation() || prop.getStorage() instanceof Column != forParent || !currentDraftSpi.__isLoaded(prop.getName())) continue;
            ImmutableType targetType = prop.getTargetType();
            ImmutableType currentType = currentDraftSpi.__type();
            String currentIdPropName = currentType.getIdProp().getName();
            Object currentId = currentDraftSpi.__isLoaded(currentIdPropName) ? currentDraftSpi.__get(currentIdPropName) : null;
            ImmutableProp mappedBy = prop.getMappedBy();
            ChildTableOperator childTableOperator = null;
            if (mappedBy != null && mappedBy.getStorage() instanceof Column) {
                childTableOperator = new ChildTableOperator(this.data.getSqlClient(), this.con, mappedBy);
            }
            Object associatedValue = currentDraftSpi.__get(prop.getName());
            LinkedHashSet<Object> associatedObjectIds = new LinkedHashSet<Object>();
            if (associatedValue instanceof List) {
                List associatedObjects = (List)associatedValue;
                if (childTableOperator != null) {
                    String targetIdPropName = prop.getTargetType().getIdProp().getName();
                    Iterator itr = new ArrayList(associatedObjects).iterator();
                    ArrayList<Object> updatingTargetIds = new ArrayList<Object>();
                    while (itr.hasNext()) {
                        DraftSpi associatedObject = (DraftSpi)itr.next();
                        if (this.isNonIdPropLoaded((ImmutableSpi)associatedObject)) {
                            associatedObject.__set(mappedBy.getName(), Internal.produce((ImmutableType)currentType, null, backRef -> ((DraftSpi)backRef).__set(currentIdPropName, currentId)));
                            continue;
                        }
                        updatingTargetIds.add(associatedObject.__get(targetIdPropName));
                        itr.remove();
                    }
                    if (!updatingTargetIds.isEmpty()) {
                        int rowCount = childTableOperator.setParent(currentId, updatingTargetIds);
                        this.addOutput(AffectedTable.of(targetType), rowCount);
                    }
                }
                for (DraftSpi associatedObject : associatedObjects) {
                    associatedObjectIds.add(this.saveAssociatedObjectAndGetId(prop, associatedObject));
                }
            } else {
                DraftSpi associatedObject = (DraftSpi)associatedValue;
                associatedObjectIds.add(this.saveAssociatedObjectAndGetId(prop, associatedObject));
            }
            ImmutableProp middleTableProp = null;
            MiddleTable middleTable = null;
            if (prop.getStorage() instanceof MiddleTable) {
                middleTableProp = prop;
                middleTable = (MiddleTable)middleTableProp.getStorage();
            } else if (mappedBy != null && mappedBy.getStorage() instanceof MiddleTable) {
                middleTableProp = mappedBy;
                middleTable = ((MiddleTable)middleTableProp.getStorage()).getInverse();
            }
            if (middleTable != null) {
                MiddleTableOperator middleTableOperator = new MiddleTableOperator(this.data.getSqlClient(), this.con, middleTable, prop.getTargetType().getIdProp().getElementClass());
                int rowCount = currentObjectType == ObjectType.NEW ? middleTableOperator.addTargetIds(currentId, associatedObjectIds) : middleTableOperator.setTargetIds(currentId, associatedObjectIds);
                this.addOutput(AffectedTable.middle(middleTableProp), rowCount);
                continue;
            }
            if (childTableOperator == null || currentObjectType == ObjectType.NEW) continue;
            if (this.data.isAutoDetachingProp(prop)) {
                List<Object> detachedTargetIds = childTableOperator.getDetachedChildIds(currentId, associatedObjectIds);
                Deleter deleter = new Deleter(new DeleteCommandImpl.Data(this.data.getSqlClient()), this.con, this.affectedRowCountMap);
                deleter.addPreHandleInput(prop.getTargetType(), detachedTargetIds);
                deleter.execute();
                continue;
            }
            if (!mappedBy.isNullable()) {
                throw new ExecutionException("Cannot disconnect child objects at the path \"" + this.path + "\" by the one-to-many association \"" + prop + "\" because the many-to-one property \"" + mappedBy + "\" is not nullable.There are two ways to resolve this issue, configure SaveCommand to automatically detach disconnected child objects of the one-to-many property \"" + prop + "\", or set the delete action of the many-to-one property \"" + mappedBy + "\" to be \"CASCADE\".");
            }
            int rowCount = childTableOperator.unsetParent(currentId, associatedObjectIds);
            this.addOutput(AffectedTable.of(targetType), rowCount);
        }
    }

    private Object saveAssociatedObjectAndGetId(ImmutableProp prop, DraftSpi associatedDraftSpi) {
        if (this.isNonIdPropLoaded((ImmutableSpi)associatedDraftSpi)) {
            AbstractSaveCommandImpl.Data associatedData = new AbstractSaveCommandImpl.Data(this.data);
            associatedData.setMode(this.data.isAutoAttachingProp(prop) ? SaveMode.UPSERT : SaveMode.UPDATE_ONLY);
            Saver associatedSaver = new Saver(this, associatedData, prop.getName());
            associatedSaver.saveImpl(associatedDraftSpi);
        }
        return associatedDraftSpi.__get(associatedDraftSpi.__type().getIdProp().getName());
    }

    private ObjectType saveSelf(DraftSpi draftSpi) {
        if (this.data.getMode() == SaveMode.INSERT_ONLY) {
            this.insert(draftSpi);
            return ObjectType.NEW;
        }
        if (this.data.getMode() == SaveMode.UPDATE_ONLY && draftSpi.__isLoaded(draftSpi.__type().getIdProp().getName())) {
            this.update(draftSpi, false);
            return ObjectType.EXISTING;
        }
        ImmutableSpi existingSpi = this.find(draftSpi);
        if (existingSpi != null) {
            String idPropName = draftSpi.__type().getIdProp().getName();
            if (draftSpi.__isLoaded(idPropName)) {
                this.update(draftSpi, false);
            } else {
                draftSpi.__set(idPropName, existingSpi.__get(idPropName));
                this.update(draftSpi, true);
            }
            return ObjectType.EXISTING;
        }
        if (this.data.getMode() == SaveMode.UPDATE_ONLY) {
            throw new ExecutionException("Cannot insert object into path \"" + this.path + "\" because insert operation for this path is disabled");
        }
        this.insert(draftSpi);
        return ObjectType.NEW;
    }

    private void insert(DraftSpi draftSpi) {
        String overrideIdentityIdSql;
        Object id;
        ImmutableType type = draftSpi.__type();
        IdGenerator idGenerator = this.data.getSqlClient().getIdGenerator(type.getJavaClass());
        Object object = id = draftSpi.__isLoaded(type.getIdProp().getName()) ? draftSpi.__get(type.getIdProp().getName()) : null;
        if (id == null) {
            if (idGenerator == null) {
                throw new ExecutionException("Cannot save \"" + type + "\" without id into path \"" + this.path + "\" because id generator is not specified");
            }
            if (idGenerator instanceof SequenceIdGenerator) {
                String sql = this.data.getSqlClient().getDialect().getSelectIdFromSequenceSql(((SequenceIdGenerator)idGenerator).getSequenceName());
                id = this.data.getSqlClient().getExecutor().execute(this.con, sql, Collections.emptyList(), stmt -> {
                    try (ResultSet rs = stmt.executeQuery();){
                        rs.next();
                        Object object = rs.getObject(1);
                        return object;
                    }
                });
                Saver.setDraftId(draftSpi, id);
            } else if (idGenerator instanceof UserIdGenerator) {
                id = ((UserIdGenerator)idGenerator).generate(type.getJavaClass());
                Saver.setDraftId(draftSpi, id);
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new ExecutionException("Illegal id generator type: \"" + idGenerator.getClass().getName() + "\", id generator must be sub type of \"" + SequenceIdGenerator.class.getName() + "\", \"" + IdentityIdGenerator.class.getName() + "\" or \"" + UserIdGenerator.class.getName() + "\"");
            }
        }
        if (type.getVersionProp() != null && !draftSpi.__isLoaded(type.getVersionProp().getName())) {
            draftSpi.__set(type.getVersionProp().getName(), (Object)0);
        }
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>();
        ArrayList values = new ArrayList();
        for (ImmutableProp prop : draftSpi.__type().getProps().values()) {
            if (!(prop.getStorage() instanceof Column) || !draftSpi.__isLoaded(prop.getName())) continue;
            props.add(prop);
            Object value = draftSpi.__get(prop.getName());
            if (value != null && prop.isReference()) {
                value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getName());
            }
            values.add(value);
        }
        if (props.isEmpty()) {
            throw new ExecutionException("Cannot insert \"" + type + "\" into path \"" + this.path + "\" without any properties");
        }
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("insert into ").sql(type.getTableName()).sql("(");
        String separator = "";
        for (ImmutableProp prop : props) {
            builder.sql(separator);
            separator = ", ";
            builder.sql(((Column)prop.getStorage()).getName());
        }
        builder.sql(")");
        if (id != null && idGenerator instanceof IdentityIdGenerator && (overrideIdentityIdSql = this.data.getSqlClient().getDialect().getOverrideIdentityIdSql()) != null) {
            builder.sql(" ").sql(overrideIdentityIdSql);
        }
        builder.sql(" values(");
        separator = "";
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            builder.sql(separator);
            separator = ", ";
            Object value = values.get(i);
            if (value != null) {
                builder.variable(value);
                continue;
            }
            builder.nullVariable(((ImmutableProp)props.get(i)).getElementClass());
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int rowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.of(type), rowCount);
        if (id == null) {
            id = this.data.getSqlClient().getExecutor().execute(this.con, this.data.getSqlClient().getDialect().getLastIdentitySql(), Collections.emptyList(), stmt -> {
                try (ResultSet rs = stmt.executeQuery();){
                    rs.next();
                    Object object = rs.getObject(1);
                    return object;
                }
            });
            Saver.setDraftId(draftSpi, id);
        }
        this.cache.save((ImmutableSpi)draftSpi, true);
    }

    private void update(DraftSpi draftSpi, boolean excludeKeyProps) {
        ImmutableType type = draftSpi.__type();
        Set<Object> excludeProps = null;
        if (excludeKeyProps) {
            excludeProps = this.data.getKeyProps(type);
        }
        if (excludeProps == null) {
            excludeProps = Collections.emptySet();
        }
        ArrayList<ImmutableProp> updatedProps = new ArrayList<ImmutableProp>();
        ArrayList<Object> updatedValues = new ArrayList<Object>();
        Integer version = null;
        for (ImmutableProp prop : type.getProps().values()) {
            if (!(prop.getStorage() instanceof Column) || !draftSpi.__isLoaded(prop.getName())) continue;
            if (prop.isVersion()) {
                version = (Integer)draftSpi.__get(prop.getName());
                continue;
            }
            if (prop.isId() || excludeProps.contains(prop)) continue;
            updatedProps.add(prop);
            Object value = draftSpi.__get(prop.getName());
            if (value != null && prop.isReference()) {
                value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getName());
            }
            updatedValues.add(value);
        }
        if (type.getVersionProp() != null && version == null) {
            throw new ExecutionException("Cannot update \"" + type + "\" at the path \"" + this.path + "\", the version property \"" + type.getVersionProp() + "\" is unloaded");
        }
        if (updatedProps.isEmpty() && version == null) {
            return;
        }
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("update ").sql(type.getTableName()).sql(" set ");
        String separator = "";
        int updatedCount = updatedProps.size();
        for (int i = 0; i < updatedCount; ++i) {
            builder.sql(separator);
            separator = ", ";
            builder.sql(((Column)((ImmutableProp)updatedProps.get(i)).getStorage()).getName()).sql(" = ");
            Object updatedValue = updatedValues.get(i);
            if (updatedValue != null) {
                builder.variable(updatedValue);
                continue;
            }
            builder.nullVariable(((ImmutableProp)updatedProps.get(i)).getElementClass());
        }
        if (version != null) {
            String versionColumName = ((Column)type.getVersionProp().getStorage()).getName();
            builder.sql(separator).sql(versionColumName).sql(" = ").sql(versionColumName).sql(" + 1");
        }
        builder.sql(" where ");
        builder.sql(((Column)type.getIdProp().getStorage()).getName()).sql(" = ").variable(draftSpi.__get(type.getIdProp().getName()));
        if (version != null) {
            builder.sql(" and ").sql(((Column)type.getVersionProp().getStorage()).getName()).sql(" = ").variable(version);
        }
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int rowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
        if (rowCount != 0) {
            this.addOutput(AffectedTable.of(type), rowCount);
            if (version != null) {
                Saver.increaseDraftVersion(draftSpi);
            }
            this.cache.save((ImmutableSpi)draftSpi);
        }
    }

    private ImmutableSpi find(DraftSpi example) {
        ImmutableSpi spi;
        ImmutableSpi cached = this.cache.find((ImmutableSpi)example);
        if (cached != null) {
            return cached;
        }
        ImmutableType type = example.__type();
        Collection<ImmutableProp> actualKeyProps = this.actualKeyProps((ImmutableSpi)example);
        List rows = (List)Queries.createQuery(this.data.getSqlClient(), type, (q, table) -> {
            for (ImmutableProp keyProp : actualKeyProps) {
                q.where(new Predicate[]{table.get(keyProp.getName()).eq((Object)example.__get(keyProp.getName()))});
            }
            return q.select(table.fetch(IdAndKeyFetchers.getFetcher(type)));
        }).execute(this.con);
        if (rows.size() > 1) {
            throw new ExecutionException("Key properties " + actualKeyProps + " cannot guarantee uniqueness at the path \"" + this.path + "\"");
        }
        ImmutableSpi immutableSpi = spi = rows.isEmpty() ? null : (ImmutableSpi)rows.get(0);
        if (spi != null) {
            this.cache.save(spi, true);
        }
        return spi;
    }

    private Collection<ImmutableProp> actualKeyProps(ImmutableSpi spi) {
        Object id;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object object = id = spi.__isLoaded(idProp.getName()) ? spi.__get(idProp.getName()) : null;
        if (id != null) {
            return Collections.singleton(idProp);
        }
        Set<ImmutableProp> keyProps = this.data.getKeyProps(type);
        if (keyProps == null) {
            throw new ExecutionException("Cannot save \"" + type + "\" without id into the path \"" + this.path + "\", key properties is not configured");
        }
        return keyProps;
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        if (affectedRowCount != 0) {
            this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
        }
    }

    private boolean isNonIdPropLoaded(ImmutableSpi spi) {
        boolean idPropLoaded = false;
        boolean nonIdPropLoaded = false;
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (!spi.__isLoaded(prop.getName())) continue;
            if (prop.isId()) {
                idPropLoaded = true;
                continue;
            }
            nonIdPropLoaded = true;
        }
        if (nonIdPropLoaded && !idPropLoaded) {
            Set<ImmutableProp> keyProps = this.data.getKeyProps(spi.__type());
            for (ImmutableProp keyProp : keyProps) {
                if (spi.__isLoaded(keyProp.getName())) continue;
                throw new ExecutionException("Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\" into the path \"" + this.path + "\", key property \"" + keyProp + "\" must be loaded when id is unloaded");
            }
        } else if (!idPropLoaded) {
            throw new ExecutionException("Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\" into the path \"" + this.path + "\", no property is loaded");
        }
        return nonIdPropLoaded;
    }

    private static void setDraftId(DraftSpi spi, Object id) {
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object convertedId = Converts.tryConvert(id, idProp.getElementClass());
        if (convertedId == null) {
            throw new ExecutionException("The type of generated id does not match the property \"" + idProp + "\"");
        }
        spi.__set(idProp.getName(), convertedId);
    }

    private static void increaseDraftVersion(DraftSpi spi) {
        ImmutableType type = spi.__type();
        ImmutableProp versionProp = type.getVersionProp();
        spi.__set(versionProp.getName(), (Object)((Integer)spi.__get(versionProp.getName()) + 1));
    }

    private static enum ObjectType {
        UNKNOWN,
        NEW,
        EXISTING;

    }
}

