/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.criteria.JoinType;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableAliasAllocator;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableWrappers;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class MutableUpdateImpl
extends AbstractMutableStatementImpl
implements MutableUpdate,
Executable<Integer>,
Ast {
    private Map<Target, Expression<?>> assignmentMap = new LinkedHashMap();
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private Table<?> table;

    public MutableUpdateImpl(SqlClient sqlClient, ImmutableType immutableType) {
        super(new TableAliasAllocator(), sqlClient);
        this.table = TableWrappers.wrap(TableImplementor.create(this, immutableType));
    }

    public <T extends Table<?>> T getTable() {
        return (T)this.table;
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, X value) {
        if (value != null) {
            return this.set(path, Expression.any().value(value));
        }
        return this.set(path, Expression.any().nullValue(((ExpressionImplementor)((Object)path)).getType()));
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, Expression<X> value) {
        boolean joinedTableUpdatable;
        this.validateMutable();
        Target target = Target.of(path);
        if (!(target.prop.getStorage() instanceof Column)) {
            throw new IllegalArgumentException("The assigned prop expression must be mapped as column");
        }
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean bl = joinedTableUpdatable = updateJoin != null && updateJoin.isJoinedTableUpdatable();
        if (!joinedTableUpdatable && target.tableImpl != TableImplementor.unwrap(this.table)) {
            throw new IllegalArgumentException("The current dialect '" + this.getSqlClient().getDialect().getClass().getName() + "' indicates that only the columns of current table can be updated");
        }
        if (this.assignmentMap.put(target, value) != null) {
            throw new IllegalStateException("Cannot update same column twice");
        }
        return this;
    }

    @Override
    public MutableUpdate where(Predicate ... predicates) {
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            this.predicates.add(predicate);
        }
        return null;
    }

    @Override
    public Integer execute(Connection con) {
        if (this.assignmentMap.isEmpty()) {
            return 0;
        }
        SqlBuilder builder = new SqlBuilder(this.getSqlClient());
        this.renderTo(builder);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.getSqlClient().getExecutor().execute(con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
    }

    @Override
    public void accept(AstVisitor visitor) {
        for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
            ((Ast)((Object)e.getKey().expr)).accept(visitor);
            ((Ast)((Object)e.getValue())).accept(visitor);
        }
        for (Predicate predicate : this.predicates) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
    }

    @Override
    public void renderTo(SqlBuilder builder) {
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        Dialect dialect = this.getSqlClient().getDialect();
        this.accept(new VisitorImpl(builder, dialect));
        builder.sql("update ").sql(table.getImmutableType().getTableName()).sql(" ").sql(table.getAlias());
        UpdateJoin updateJoin = dialect.getUpdateJoin();
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.UNNECESSARY) {
            for (TableImplementor<?> child : table.getChildren()) {
                child.renderTo(builder);
            }
        }
        builder.sql(" set ");
        this.renderAssignments(builder);
        this.renderTables(builder);
        this.renderDeeperJoins(builder);
        this.renderPredicates(builder);
    }

    private void renderAssignments(SqlBuilder builder) {
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean withTargetPrefix = updateJoin != null && updateJoin.isJoinedTableUpdatable() && table.getChildren().stream().anyMatch(it -> builder.isTableUsed((Table<?>)it));
        String separator = "";
        for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
            builder.sql(separator);
            this.renderTarget(builder, e.getKey(), withTargetPrefix);
            builder.sql(" = ");
            ((Ast)((Object)e.getValue())).renderTo(builder);
            separator = ", ";
        }
    }

    private void renderTarget(SqlBuilder builder, Target target, boolean withPrefix) {
        if (withPrefix) {
            builder.sql(target.tableImpl.getAlias()).sql(".");
        }
        builder.sql(((Column)target.prop.getStorage()).getName());
    }

    private void renderTables(SqlBuilder builder) {
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        if (table.getChildren().stream().anyMatch(it -> builder.isTableUsed((Table<?>)it))) {
            switch (this.getSqlClient().getDialect().getUpdateJoin().getFrom()) {
                case AS_ROOT: {
                    table.renderTo(builder);
                    break;
                }
                case AS_JOIN: {
                    builder.sql(" from ");
                    String separator = "";
                    for (TableImplementor<?> child : table.getChildren()) {
                        builder.sql(separator);
                        child.renderJoinAsFrom(builder, TableImplementor.RenderMode.FROM_ONLY);
                        separator = ",";
                    }
                    break;
                }
            }
        }
    }

    private void renderDeeperJoins(SqlBuilder builder) {
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && table.getChildren().stream().anyMatch(it -> builder.isTableUsed((Table<?>)it))) {
            for (TableImplementor<?> child : table.getChildren()) {
                child.renderJoinAsFrom(builder, TableImplementor.RenderMode.DEEPER_JOIN_ONLY);
            }
        }
    }

    private void renderPredicates(SqlBuilder builder) {
        TableImplementor<?> table = TableImplementor.unwrap(this.table);
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        String separator = " where ";
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN) {
            if (table.getChildren().stream().anyMatch(builder::isTableUsed)) {
                for (TableImplementor tableImplementor : table.getChildren()) {
                    builder.sql(separator);
                    separator = " and ";
                    tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.WHERE_ONLY);
                }
            }
        }
        for (Predicate predicate : this.predicates) {
            builder.sql(separator);
            separator = " and ";
            ((Ast)((Object)predicate)).renderTo(builder);
        }
    }

    private static class Target {
        TableImplementor<?> tableImpl;
        ImmutableProp prop;
        PropExpression<?> expr;

        private Target(TableImplementor<?> tableImpl, ImmutableProp prop, PropExpression<?> expr) {
            this.tableImpl = tableImpl;
            this.prop = prop;
            this.expr = expr;
        }

        static Target of(PropExpression<?> expr) {
            PropExpressionImpl exprImpl = (PropExpressionImpl)expr;
            TableImplementor<?> targetTable = TableImplementor.unwrap(exprImpl.getTableImplementor());
            if (targetTable.getParent() != null && exprImpl.getProp().isId()) {
                return new Target(targetTable.getParent(), targetTable.getJoinProp(), expr);
            }
            return new Target(targetTable, exprImpl.getProp(), expr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.tableImpl.equals(target.tableImpl) && this.prop.equals(target.prop);
        }

        public int hashCode() {
            return Objects.hash(this.tableImpl, this.prop);
        }
    }

    private static class VisitorImpl
    extends UseTableVisitor {
        private Dialect dialect;

        public VisitorImpl(SqlBuilder sqlBuilder, Dialect dialect) {
            super(sqlBuilder);
            this.dialect = dialect;
        }

        @Override
        public void visitTableReference(Table<?> table, ImmutableProp prop) {
            super.visitTableReference(table, prop);
            this.validateTable(TableImplementor.unwrap(table));
        }

        private void validateTable(TableImplementor<?> tableImpl) {
            if (this.getSqlBuilder().isTableUsed(tableImpl)) {
                if (tableImpl.getParent() != null && this.dialect.getUpdateJoin() == null) {
                    throw new ExecutionException("Table joins for update statement is forbidden by the current dialect, but there is a join '" + tableImpl + "'.");
                }
                if (tableImpl.getParent() != null && tableImpl.getParent().getParent() == null && tableImpl.getJoinType() != JoinType.INNER && this.dialect.getUpdateJoin() != null && this.dialect.getUpdateJoin().getFrom() == UpdateJoin.From.AS_JOIN) {
                    throw new ExecutionException("The first level table joins cannot be outer join because current dialect '" + this.dialect.getClass().getName() + "' indicates that the first level table joins in update statement must be rendered as 'from' clause, but there is a first level table join whose join type is outer: '" + tableImpl + "'.");
                }
            }
            if (tableImpl.getParent() != null) {
                this.validateTable(tableImpl.getParent());
            }
        }
    }
}

