/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class MiddleTableOperator {
    private SqlClient sqlClient;
    private Connection con;
    private MiddleTable middleTable;
    private Expression<?> targetIdExpression;

    MiddleTableOperator(SqlClient sqlClient, Connection con, MiddleTable middleTable, Class<?> targetIdType) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.middleTable = middleTable;
        this.targetIdExpression = Expression.any().nullValue(targetIdType);
    }

    List<Object> getTargetIds(Object id) {
        SqlBuilder builder = new SqlBuilder(this.sqlClient);
        builder.sql("select ").sql(this.middleTable.getTargetJoinColumnName()).sql(" from ").sql(this.middleTable.getTableName()).sql(" where ").sql(this.middleTable.getJoinColumnName()).sql(" = ").variable(id);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult._1(), sqlResult._2(), Collections.singletonList(this.targetIdExpression));
    }

    int addTargetIds(Object id, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.add(new OneToManyReader(id, (Collection<Object>)set));
    }

    int add(IdPairReader reader) {
        SqlBuilder builder = new SqlBuilder(this.sqlClient);
        builder.sql("insert into ").sql(this.middleTable.getTableName()).sql("(").sql(this.middleTable.getJoinColumnName()).sql(", ").sql(this.middleTable.getTargetJoinColumnName()).sql(") values ");
        String separator = "";
        while (reader.read()) {
            builder.sql(separator);
            separator = ", ";
            builder.sql("(").variable(reader.sourceId()).sql(", ").variable(reader.targetId()).sql(")");
        }
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
    }

    int removeTargetIds(Object id, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.remove(new OneToManyReader(id, (Collection<Object>)set));
    }

    int remove(IdPairReader reader) {
        SqlBuilder builder = new SqlBuilder(this.sqlClient);
        builder.sql("delete from ").sql(this.middleTable.getTableName()).sql(" where (").sql(this.middleTable.getJoinColumnName()).sql(", ").sql(this.middleTable.getTargetJoinColumnName()).sql(") in (");
        String separator = "";
        while (reader.read()) {
            builder.sql(separator);
            separator = ", ";
            builder.sql("(").variable(reader.sourceId()).sql(", ").variable(reader.targetId()).sql(")");
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
    }

    int setTargetIds(Object id, Collection<Object> targetIds) {
        LinkedHashSet<Object> oldTargetIds = new LinkedHashSet<Object>(this.getTargetIds(id));
        LinkedHashSet<Object> addingTargetIds = new LinkedHashSet<Object>(targetIds);
        addingTargetIds.removeAll(oldTargetIds);
        LinkedHashSet<Object> removingTargetIds = new LinkedHashSet<Object>(oldTargetIds);
        removingTargetIds.removeAll(targetIds);
        return this.removeTargetIds(id, removingTargetIds) + this.addTargetIds(id, addingTargetIds);
    }

    private static class OneToManyReader
    implements IdPairReader {
        private Object sourceId;
        private Iterator<Object> targetIdItr;
        private Object currentTargetId;
        private int index = -1;

        OneToManyReader(Object sourceId, Collection<Object> targetIds) {
            this.sourceId = sourceId;
            this.targetIdItr = targetIds.iterator();
        }

        @Override
        public boolean read() {
            if (this.targetIdItr.hasNext()) {
                this.currentTargetId = this.targetIdItr.next();
                return true;
            }
            return false;
        }

        @Override
        public Object sourceId() {
            return this.sourceId;
        }

        @Override
        public Object targetId() {
            return this.currentTargetId;
        }
    }

    static interface IdPairReader {
        public boolean read();

        public Object sourceId();

        public Object targetId();
    }
}

