/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.BatchSaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SimpleSaveCommandImpl;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveCommand;

public class EntitiesImpl
implements Entities {
    private SqlClient sqlClient;

    public EntitiesImpl(SqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    @Override
    public <E> SimpleSaveCommand<E> saveCommand(E entity) {
        return new SimpleSaveCommandImpl<E>(this.sqlClient, entity);
    }

    @Override
    public <E> BatchSaveCommand<E> batchSaveCommand(Collection<E> entities) {
        return new BatchSaveCommandImpl<E>(this.sqlClient, entities);
    }

    @Override
    public DeleteCommand deleteCommand(Class<?> entityType, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id is collection, do you want to call batchDeleteCommand?");
        }
        return this.batchDeleteCommand(entityType, Collections.singleton(id));
    }

    @Override
    public DeleteCommand batchDeleteCommand(Class<?> entityType, Collection<?> ids) {
        ImmutableType immutableType = ImmutableType.get(entityType);
        return new DeleteCommandImpl(this.sqlClient, immutableType, ids);
    }

    @Override
    public DeleteCommand batchDeleteCommand(Class<?> entityType, Object ... ids) {
        return this.batchDeleteCommand(entityType, Arrays.asList(ids));
    }
}

