/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractSaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.ImmutableCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;

class BatchSaveCommandImpl<E>
extends AbstractSaveCommandImpl<BatchSaveCommand<E>>
implements BatchSaveCommand<E> {
    private Collection<E> entities;

    BatchSaveCommandImpl(SqlClient sqlClient, Collection<E> entities) {
        super(sqlClient, null);
        this.entities = entities;
    }

    private BatchSaveCommandImpl(BatchSaveCommandImpl<E> base, AbstractSaveCommandImpl.Data data) {
        super(base.sqlClient, data);
        this.entities = base.entities;
    }

    @Override
    public BatchSaveResult<E> execute(Connection con) {
        ImmutableCache cache = new ImmutableCache(this.data);
        LinkedHashMap<AffectedTable, Integer> affectedRowCountMap = new LinkedHashMap<AffectedTable, Integer>();
        List simpleSaveResults = this.entities.stream().map(it -> new Saver(this.data, con, cache, affectedRowCountMap).save(it)).collect(Collectors.toList());
        return new BatchSaveResult(affectedRowCountMap, simpleSaveResults);
    }

    @Override
    BatchSaveCommand<E> create(AbstractSaveCommandImpl.Data data) {
        return new BatchSaveCommandImpl<E>(this, data);
    }
}

