/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.OneToMany;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DeleteAction;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.mutation.AbstractSaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.meta.Column;

abstract class AbstractSaveCommandImpl<C extends AbstractSaveCommand<C>>
implements AbstractSaveCommand<C> {
    SqlClient sqlClient;
    Data data;

    AbstractSaveCommandImpl(SqlClient sqlClient, Data data) {
        this.sqlClient = sqlClient;
        this.data = data != null ? data.freeze() : new Data(sqlClient).freeze();
    }

    @Override
    public C configure(Consumer<AbstractSaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.mode == SaveMode.UPSERT && newData.keyPropMultiMap.isEmpty() && !newData.autoAttachingAll && newData.autoDetachingSet.isEmpty() && newData.autoAttachingSet.isEmpty()) {
            return (C)this;
        }
        return this.create(newData);
    }

    abstract C create(Data var1);

    static class Data
    implements AbstractSaveCommand.Cfg {
        private SqlClient sqlClient;
        private boolean frozen;
        private SaveMode mode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoAttachingAll;
        private Set<ImmutableProp> autoAttachingSet;
        private Set<ImmutableProp> autoDetachingSet;

        Data(SqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>();
            this.autoDetachingSet = new LinkedHashSet<ImmutableProp>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoAttachingAll = base.autoAttachingAll;
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>(base.autoAttachingSet);
            this.autoDetachingSet = new LinkedHashSet<ImmutableProp>(base.autoDetachingSet);
        }

        public SqlClient getSqlClient() {
            return this.sqlClient;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoAttachingProp(ImmutableProp prop) {
            return this.autoAttachingAll || this.autoAttachingSet.contains(prop);
        }

        public boolean isAutoDetachingProp(ImmutableProp prop) {
            return this.autoDetachingSet.contains(prop) || prop.getMappedBy() != null && prop.getMappedBy().getDeleteAction() == DeleteAction.CASCADE;
        }

        @Override
        public AbstractSaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractSaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (prop.isAssociation() || !(prop.getStorage() instanceof Column)) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not a scalar property with storage");
                }
                if (prop.isNullable()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is nullable");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractSaveCommand.Cfg setKeyProps(Class<?> entityType, String ... props) {
            ImmutableType type = ImmutableType.get(entityType);
            return this.setKeyProps((ImmutableProp[])Arrays.stream(props).map(arg_0 -> ((ImmutableType)type).getProp(arg_0)).toArray(ImmutableProp[]::new));
        }

        @Override
        public <T extends Table<?>> AbstractSaveCommand.Cfg setKeyProps(Class<T> tableType, Consumer<AbstractSaveCommand.KeyPropCfg<T>> block) {
            KeyPropCfgImpl<T> keyPropCfg = new KeyPropCfgImpl<T>(tableType);
            block.accept(keyPropCfg);
            return this.setKeyProps(keyPropCfg.getProps().toArray(new ImmutableProp[0]));
        }

        @Override
        public AbstractSaveCommand.Cfg setAutoAttachingAll() {
            this.autoAttachingAll = true;
            return this;
        }

        @Override
        public AbstractSaveCommand.Cfg setAutoAttaching(ImmutableProp prop) {
            this.validate();
            this.autoAttachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractSaveCommand.Cfg setAutoAttaching(Class<?> entityType, String prop) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = immutableType.getProp(prop);
            return this.setAutoAttaching(immutableProp);
        }

        @Override
        public <T extends Table<?>> AbstractSaveCommand.Cfg setAutoAttaching(Class<T> tableType, Function<T, Table<?>> block) {
            return this.setAutoAttaching(ImmutableProps.join(tableType, block));
        }

        @Override
        public AbstractSaveCommand.Cfg setAutoDetaching(ImmutableProp prop) {
            this.validate();
            if (!prop.isEntityList() || prop.getAssociationAnnotation().annotationType() != OneToMany.class) {
                throw new IllegalArgumentException("Cannot set auto detaching for '" + prop + "' because it is not one-to-many property");
            }
            this.autoDetachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractSaveCommand.Cfg setAutoDetaching(Class<?> entityType, String prop) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = immutableType.getProp(prop);
            return this.setAutoDetaching(immutableProp);
        }

        @Override
        public <T extends TableEx<?>> AbstractSaveCommand.Cfg setAutoDetaching(Class<T> tableType, Function<T, Table<?>> block) {
            return this.setAutoDetaching(ImmutableProps.join(tableType, block));
        }

        public Data freeze() {
            if (!this.frozen) {
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoAttachingSet = Collections.unmodifiableSet(this.autoAttachingSet);
                this.autoDetachingSet = Collections.unmodifiableSet(this.autoDetachingSet);
                this.frozen = true;
            }
            return this;
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }

    private static class KeyPropCfgImpl<T extends Table<?>>
    implements AbstractSaveCommand.KeyPropCfg<T> {
        private Class<T> tableType;
        private List<ImmutableProp> props = new ArrayList<ImmutableProp>();

        KeyPropCfgImpl(Class<T> tableType) {
            this.tableType = tableType;
        }

        public List<ImmutableProp> getProps() {
            return this.props;
        }

        @Override
        public AbstractSaveCommand.KeyPropCfg<T> add(Function<T, PropExpression<?>> block) {
            ImmutableProp prop = ImmutableProps.get(this.tableType, block);
            this.props.add(prop);
            return this;
        }
    }
}

