/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Arrays;
import java.util.Collection;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AggregationExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparisonPredicate;
import org.babyfish.jimmer.sql.ast.impl.InCollectionPredicate;
import org.babyfish.jimmer.sql.ast.impl.InSubQueryPredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NullExpression;
import org.babyfish.jimmer.sql.ast.impl.NullityPredicate;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;

public interface ExpressionImplementor<T>
extends Expression<T> {
    public Class<T> getType();

    public int precedence();

    @Override
    default public Predicate eq(Expression<T> other) {
        if (other instanceof NullExpression) {
            return this.isNull();
        }
        if (this instanceof NullExpression) {
            return other.isNull();
        }
        return new ComparisonPredicate.Eq(this, other);
    }

    @Override
    default public Predicate eq(T other) {
        return this.eq((T)Literals.any(other));
    }

    @Override
    default public Predicate ne(Expression<T> other) {
        if (other instanceof NullExpression) {
            return this.isNotNull();
        }
        if (this instanceof NullExpression) {
            return other.isNotNull();
        }
        return new ComparisonPredicate.Ne(this, other);
    }

    @Override
    default public Predicate ne(T other) {
        return this.ne((T)Literals.any(other));
    }

    @Override
    default public Predicate isNull() {
        return new NullityPredicate(this, false);
    }

    @Override
    default public Predicate isNotNull() {
        return new NullityPredicate(this, true);
    }

    @Override
    default public Predicate in(Collection<T> values) {
        return new InCollectionPredicate(this, values, false);
    }

    @Override
    default public Predicate in(T ... values) {
        return this.in((Collection<T>)Arrays.asList(values));
    }

    @Override
    default public Predicate notIn(Collection<T> values) {
        return new InCollectionPredicate(this, values, true);
    }

    @Override
    default public Predicate notIn(T ... values) {
        return this.notIn((Collection<T>)Arrays.asList(values));
    }

    @Override
    default public Predicate in(TypedSubQuery<T> subQuery) {
        return new InSubQueryPredicate(this, subQuery, false);
    }

    @Override
    default public Predicate notIn(TypedSubQuery<T> subQuery) {
        return new InSubQueryPredicate(this, subQuery, true);
    }

    @Override
    default public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    default public NumericExpression<Long> count(boolean distinct) {
        if (distinct) {
            return new AggregationExpression.CountDistinct(this);
        }
        return new AggregationExpression.Count(this);
    }

    @Override
    default public Expression<T> coalesce(T defaultValue) {
        return this.coalesceBuilder().or(defaultValue).build();
    }

    @Override
    default public CoalesceBuilder<T> coalesceBuilder() {
        return new CoalesceBuilder(this);
    }
}

