/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.query.ConfigurableTypedSubQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTableEx;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.fetcher.FilterArgs;

public class FilterArgsImpl<T extends Table<?>>
implements FilterArgs<T> {
    private Sortable sortable;
    private T table;
    private Object key;
    private Collection<Object> keys;

    public static <T extends Table<?>> FilterArgs<T> singleLoaderArgs(Sortable sortable, T table, Object key) {
        return new FilterArgsImpl<T>(sortable, table, Objects.requireNonNull(key, "key cannot be null"), null);
    }

    public static <T extends Table<?>> FilterArgs<T> batchLoaderArgs(Sortable sortable, T table, Collection<Object> keys) {
        return new FilterArgsImpl<T>(sortable, table, null, Objects.requireNonNull(keys, "keys cannot be null"));
    }

    private FilterArgsImpl(Sortable sortable, T table, Object key, Collection<Object> keys) {
        this.sortable = sortable;
        this.table = table;
        this.key = key;
        this.keys = keys != null ? Collections.unmodifiableCollection(keys) : null;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    @Override
    public <K> K getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Cannot get the single key in BatchDataLoader");
        }
        return (K)this.key;
    }

    @Override
    public <K> Collection<K> getKeys() {
        return this.keys != null ? this.keys : Collections.singleton(this.key);
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        return this.sortable.where(predicates);
    }

    @Override
    public Sortable orderBy(Expression<?> expression) {
        return this.sortable.orderBy(expression);
    }

    @Override
    public Sortable orderBy(Expression<?> expression, OrderMode orderMode) {
        return this.sortable.orderBy(expression, orderMode);
    }

    @Override
    public Sortable orderBy(Expression<?> expression, OrderMode orderMode, NullOrderMode nullOrderMode) {
        return this.sortable.orderBy(expression, orderMode, nullOrderMode);
    }

    public <X extends Table<?>, R> ConfigurableTypedSubQuery<R> createSubQuery(Class<X> tableType, BiFunction<MutableSubQuery, X, ConfigurableTypedSubQuery<R>> block) {
        return this.sortable.createSubQuery(tableType, block);
    }

    public <X extends Table<?>> MutableSubQuery createWildSubQuery(Class<X> tableType, BiConsumer<MutableSubQuery, X> block) {
        return this.sortable.createWildSubQuery(tableType, block);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>, R> ConfigurableTypedSubQuery<R> createAssociationSubQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiFunction<MutableSubQuery, AssociationTableEx<SE, ST, TE, TT>, ConfigurableTypedSubQuery<R>> block) {
        return this.sortable.createAssociationSubQuery(sourceTableType, targetTableGetter, block);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>, R> MutableSubQuery createAssociationWildSubQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiConsumer<MutableSubQuery, AssociationTableEx<SE, ST, TE, TT>> block) {
        return this.sortable.createAssociationWildSubQuery(sourceTableType, targetTableGetter, block);
    }
}

