/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheWrapper;
import org.babyfish.jimmer.sql.cache.Caches;

class CachesImpl
implements Caches {
    private final CacheFactory cacheFactory;
    private final Map<ImmutableType, Cache<?, ?>> objectCacheMap;
    private final Map<ImmutableProp, Cache<?, ?>> associatedIdCacheMap;
    private final Map<ImmutableProp, Cache<?, List<?>>> associatedIdListCacheMap;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Object DISABLED = new Object();

    CachesImpl(CacheFactory cacheFactory, Map<ImmutableType, Cache<?, ?>> objectCacheMap, Map<ImmutableProp, Cache<?, ?>> associatedIdCacheMap, Map<ImmutableProp, Cache<?, List<?>>> associatedIdListCacheMap) {
        this.cacheFactory = cacheFactory;
        this.objectCacheMap = new HashMap(objectCacheMap);
        this.associatedIdCacheMap = new HashMap(associatedIdCacheMap);
        this.associatedIdListCacheMap = new HashMap(associatedIdListCacheMap);
    }

    @Override
    public <K, V> Cache<K, V> getObjectCache(ImmutableType type) {
        return CacheWrapper.wrap(this.getObjectCacheImpl(type), CacheWrapper.Type.OBJECT);
    }

    @Override
    public <K, V> Cache<K, V> getAssociatedIdCache(ImmutableProp prop) {
        return CacheWrapper.wrap(this.getAssociatedIdCacheImpl(prop), CacheWrapper.Type.ASSOCIATED_ID);
    }

    @Override
    public <K, V> Cache<K, List<V>> getAssociatedIdListCache(ImmutableProp prop) {
        return CacheWrapper.wrap(this.getAssociatedIdListCacheImpl(prop), CacheWrapper.Type.ASSOCIATED_ID_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> getObjectCacheImpl(ImmutableType type) {
        Cache<?, ?> cache;
        Lock lock = this.rwl.readLock();
        lock.lock();
        try {
            cache = this.objectCacheMap.get(type);
            if (cache != null || this.objectCacheMap.containsKey(type)) {
                Cache<?, ?> cache2 = cache;
                return cache2;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.rwl.writeLock();
        lock.lock();
        try {
            cache = this.objectCacheMap.get(type);
            if (cache != null || this.objectCacheMap.containsKey(type)) {
                Cache<?, ?> cache3 = cache;
                return cache3;
            }
            if (this.cacheFactory != null) {
                cache = this.cacheFactory.createObjectCache(type);
            }
            this.objectCacheMap.put(type, cache);
            Cache<?, ?> cache4 = cache;
            return cache4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> getAssociatedIdCacheImpl(ImmutableProp prop) {
        Cache<?, ?> cache;
        Lock lock = this.rwl.readLock();
        lock.lock();
        try {
            cache = this.associatedIdCacheMap.get(prop);
            if (cache != null || this.associatedIdCacheMap.containsKey(prop)) {
                Cache<?, ?> cache2 = cache;
                return cache2;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.rwl.writeLock();
        lock.lock();
        try {
            cache = this.associatedIdCacheMap.get(prop);
            if (cache != null || this.associatedIdCacheMap.containsKey(prop)) {
                Cache<?, ?> cache3 = cache;
                return cache3;
            }
            CachesImpl.validateForAssociatedTargetId(prop);
            if (this.cacheFactory != null) {
                cache = this.cacheFactory.createAssociatedIdCache(prop);
            }
            this.associatedIdCacheMap.put(prop, cache);
            Cache<?, ?> cache4 = cache;
            return cache4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, List<V>> getAssociatedIdListCacheImpl(ImmutableProp prop) {
        Cache<?, List<?>> cache;
        Lock lock = this.rwl.readLock();
        lock.lock();
        try {
            cache = this.associatedIdListCacheMap.get(prop);
            if (cache != null || this.associatedIdListCacheMap.containsKey(prop)) {
                Cache<?, List<?>> cache2 = cache;
                return cache2;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.rwl.writeLock();
        lock.lock();
        try {
            cache = this.associatedIdListCacheMap.get(prop);
            if (cache != null || this.associatedIdListCacheMap.containsKey(prop)) {
                Cache<?, List<?>> cache3 = cache;
                return cache3;
            }
            CachesImpl.validateForAssociationTargetIdList(prop);
            if (this.cacheFactory != null) {
                cache = this.cacheFactory.createAssociatedIdListCache(prop);
            }
            this.associatedIdListCacheMap.put(prop, cache);
            Cache<?, List<?>> cache4 = cache;
            return cache4;
        }
        finally {
            lock.unlock();
        }
    }

    public static void validateForAssociatedTargetId(ImmutableProp prop) {
        if (!prop.isReference()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not reference association");
        }
    }

    public static void validateForAssociationTargetIdList(ImmutableProp prop) {
        if (!prop.isEntityList()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not list association");
        }
    }
}

