/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheConfig;

public interface Caches {
    default public <K, V> Cache<K, V> getObjectCache(Class<V> type) {
        return this.getObjectCache(ImmutableType.get(type));
    }

    public <K, V> Cache<K, V> getObjectCache(ImmutableType var1);

    default public <K, V, ST extends Table<?>> Cache<K, V> getAssociatedIdCache(Class<ST> sourceTableType, Function<ST, ? extends Table<?>> targetTableGetter) {
        return this.getAssociatedIdCache(ImmutableProps.join(sourceTableType, targetTableGetter));
    }

    public <K, V> Cache<K, V> getAssociatedIdCache(ImmutableProp var1);

    default public <K, V, ST extends Table<?>> Cache<K, List<V>> getAssociatedIdListCache(Class<ST> sourceTableType, Function<ST, Table<?>> targetTableGetter) {
        return this.getAssociatedIdListCache(ImmutableProps.join(sourceTableType, targetTableGetter));
    }

    public <K, V> Cache<K, List<V>> getAssociatedIdListCache(ImmutableProp var1);

    public static Caches of(Consumer<CacheConfig> block) {
        CacheConfig cfg = new CacheConfig();
        block.accept(cfg);
        return cfg.build();
    }
}

