/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.QueryCacheEnvironment;

class CacheWrapper<K, V>
implements Cache<K, V> {
    private static final ThreadLocal<Set<Cache<?, ?>>> LOADING_CACHES_LOCAL = new ThreadLocal();
    private final Cache<K, V> raw;
    private final Type type;

    private CacheWrapper(Cache<K, V> raw, Type type) {
        this.raw = raw;
        this.type = type;
    }

    public static <K, V> Cache<K, V> wrap(Cache<K, V> cache, Type type) {
        if (cache == null) {
            return null;
        }
        if (cache instanceof CacheWrapper && ((CacheWrapper)cache).type != type) {
            throw new AssertionError((Object)"");
        }
        Set<Cache<?, ?>> disabledCaches = LOADING_CACHES_LOCAL.get();
        if (disabledCaches != null && disabledCaches.contains(cache)) {
            return null;
        }
        return new CacheWrapper<K, V>(cache, type);
    }

    public static <K, V> Cache<K, V> unwrap(Cache<K, V> cache) {
        if (cache instanceof CacheWrapper) {
            CacheWrapper wrapper = (CacheWrapper)cache;
            return wrapper.raw;
        }
        return cache;
    }

    @Override
    public V get(K key, QueryCacheEnvironment<K, V> env) {
        return (V)this.execute(() -> this.validateResult(this.raw.get(key, env)));
    }

    @Override
    public Map<K, V> getAll(Collection<K> keys, QueryCacheEnvironment<K, V> env) {
        return this.execute(() -> this.validateResult(this.raw.getAll(keys, env)));
    }

    @Override
    public void delete(K key, CacheEnvironment env) {
        this.execute(() -> {
            this.raw.delete(key, env);
            return null;
        });
    }

    @Override
    public void deleteAll(Collection<K> keys, CacheEnvironment env) {
        this.execute(() -> {
            this.raw.deleteAll(keys, env);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R execute(Supplier<R> block) {
        Set<Cache<Object, Object>> disabledCaches = LOADING_CACHES_LOCAL.get();
        if (disabledCaches == null) {
            disabledCaches = Collections.singleton(this.raw);
            LOADING_CACHES_LOCAL.set(disabledCaches);
        } else if (disabledCaches.size() == 1) {
            Cache<Object, Object> oldRaw = disabledCaches.iterator().next();
            disabledCaches = new HashSet();
            disabledCaches.add(oldRaw);
            disabledCaches.add(this.raw);
            LOADING_CACHES_LOCAL.set(disabledCaches);
        } else {
            disabledCaches.add(this.raw);
        }
        try {
            R r = block.get();
            return r;
        }
        finally {
            if (disabledCaches.size() < 2) {
                LOADING_CACHES_LOCAL.remove();
            } else {
                disabledCaches.remove(this.raw);
            }
        }
    }

    private <R> R validateResult(R result) {
        switch (this.type) {
            case ASSOCIATED_ID: {
                for (Object value : ((Map)result).values()) {
                    this.validateValue(value);
                }
                break;
            }
            case ASSOCIATED_ID_LIST: {
                for (List list : ((Map)result).values()) {
                    if (list == null) continue;
                    for (Object value : list) {
                        this.validateValue(value);
                    }
                }
                break;
            }
        }
        return result;
    }

    private void validateValue(Object value) {
        if (value instanceof ImmutableSpi) {
            throw new IllegalArgumentException("Illegal cache " + this.raw + ", " + this.type.getName() + " can only return id, should not return object");
        }
    }

    static enum Type {
        OBJECT("object cache"),
        ASSOCIATED_ID("associated id ache"),
        ASSOCIATED_ID_LIST("associated id list cache");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

