/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.cache.CacheFilter;

class CacheFilterImpl
implements CacheFilter {
    private final NavigableMap<String, Object> args;

    CacheFilterImpl(Map<String, Object> args) {
        this.args = args == null || args.isEmpty() ? Collections.emptyNavigableMap() : new TreeMap<String, Object>(args);
    }

    public CacheFilterImpl(List<Tuple2<String, Object>> tuples) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Tuple2<String, Object> tuple : tuples) {
            map.put(tuple._1(), tuple._2());
        }
        this.args = map;
    }

    @Override
    public NavigableMap<String, Object> toCacheArgs() {
        return this.args;
    }

    public int hashCode() {
        return Objects.hash(this.args);
    }

    public String toString() {
        return "CacheFilterImpl{args=" + this.args + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheFilterImpl that = (CacheFilterImpl)o;
        return this.args.equals(that.args);
    }
}

