/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.sql.Connection;
import java.util.Objects;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.cache.CacheFilter;

public class CacheEnvironment {
    private final SqlClient sqlClient;
    private final Connection connection;
    private final CacheFilter filter;

    public CacheEnvironment(SqlClient sqlClient, Connection connection) {
        this(sqlClient, connection, null);
    }

    public CacheEnvironment(SqlClient sqlClient, Connection connection, CacheFilter filter) {
        this.sqlClient = Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
        this.connection = Objects.requireNonNull(connection, "connection cannot be null");
        this.filter = filter;
    }

    public SqlClient getSqlClient() {
        return this.sqlClient;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public CacheFilter getFilter() {
        return this.filter;
    }

    public int hashCode() {
        return Objects.hash(this.sqlClient, this.connection, this.filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEnvironment that = (CacheEnvironment)o;
        return this.sqlClient.equals(that.sqlClient) && this.connection.equals(that.connection) && Objects.equals(this.filter, that.filter);
    }

    public String toString() {
        return super.toString();
    }
}

