/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheWrapper;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;

public class CacheConfig {
    private CacheFactory cacheFactory;
    private final Map<ImmutableType, Cache<?, ?>> objectCacheMap = new HashMap();
    private final Map<ImmutableProp, Cache<?, ?>> associatedIdCacheMap = new HashMap();
    private final Map<ImmutableProp, Cache<?, List<?>>> associatedIdListCacheMap = new HashMap();

    public CacheConfig setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        return this;
    }

    public <T> CacheConfig setObjectCache(Class<T> type, Cache<?, T> cache) {
        ImmutableType immutableType = ImmutableType.get(type);
        this.objectCacheMap.put(immutableType, CacheWrapper.unwrap(cache));
        return this;
    }

    public <ST extends Table<?>> CacheConfig setAssociatedIdCache(Class<ST> sourceTableType, Function<ST, Table<?>> targetTableGetter, Cache<?, ?> cache) {
        ImmutableProp prop = ImmutableProps.join(sourceTableType, targetTableGetter);
        CachesImpl.validateForAssociatedTargetId(prop);
        this.associatedIdCacheMap.put(prop, CacheWrapper.unwrap(cache));
        return this;
    }

    public <T, ST extends Table<?>, TT extends Table<T>> CacheConfig setAssociatedIdListCache(Class<ST> sourceTableType, Function<ST, Table<?>> targetTableGetter, Cache<?, List<?>> cache) {
        ImmutableProp prop = ImmutableProps.join(sourceTableType, targetTableGetter);
        CachesImpl.validateForAssociationTargetIdList(prop);
        this.associatedIdListCacheMap.put(prop, CacheWrapper.unwrap(cache));
        return this;
    }

    Caches build() {
        return new CachesImpl(this.cacheFactory, this.objectCacheMap, this.associatedIdCacheMap, this.associatedIdListCacheMap);
    }
}

