/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.BatchEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SimpleEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.QueryCacheEnvironment;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.fetcher.impl.Fetchers;
import org.babyfish.jimmer.sql.runtime.Converters;

public class EntitiesImpl
implements Entities {
    private SqlClient sqlClient;

    public EntitiesImpl(SqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    @Override
    public <E> E findById(Class<E> entityType, Object id) {
        return (E)this.sqlClient.getConnectionManager().execute(con -> this.findById(entityType, id, (Connection)con));
    }

    @Override
    public <E> List<E> findByIds(Class<E> entityType, Collection<?> ids) {
        return this.sqlClient.getConnectionManager().execute(con -> this.findByIds(entityType, ids, (Connection)con));
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Class<E> entityType, Collection<ID> ids) {
        return this.sqlClient.getConnectionManager().execute(con -> this.findMapByIds(entityType, ids, (Connection)con));
    }

    @Override
    public <E> E findById(Fetcher<E> fetcher, Object id) {
        return (E)this.sqlClient.getConnectionManager().execute(con -> this.findById(fetcher, id, (Connection)con));
    }

    @Override
    public <E> List<E> findByIds(Fetcher<E> fetcher, Collection<?> ids) {
        return this.sqlClient.getConnectionManager().execute(con -> this.findByIds(fetcher, ids, (Connection)con));
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Collection<ID> ids) {
        return this.sqlClient.getConnectionManager().execute(con -> this.findMapByIds(fetcher, ids, (Connection)con));
    }

    @Override
    public <E> E findById(Class<E> entityType, Object id, Connection con) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(entityType, null, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    @Override
    public <E> List<E> findByIds(Class<E> entityType, Collection<?> ids, Connection con) {
        return this.findByIds(entityType, null, ids, con);
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Class<E> entityType, Collection<ID> ids, Connection con) {
        String idPropName = ImmutableType.get(entityType).getIdProp().getName();
        return this.findByIds(entityType, null, ids, con).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idPropName), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    @Override
    public <E> E findById(Fetcher<E> fetcher, Object id, Connection con) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(fetcher.getJavaClass(), fetcher, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    @Override
    public <E> List<E> findByIds(Fetcher<E> fetcher, Collection<?> ids, Connection con) {
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids, con);
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Collection<ID> ids, Connection con) {
        String idPropName = ImmutableType.get(fetcher.getJavaClass()).getIdProp().getName();
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids, con).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idPropName), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    private <E> List<E> findByIds(Class<E> entityType, final Fetcher<E> fetcher, Collection<?> ids, Connection con) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet distinctIds = ids instanceof Set ? (LinkedHashSet)ids : new LinkedHashSet(ids);
        ImmutableType immutableType = ImmutableType.get(entityType);
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : distinctIds) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        Cache cache = this.sqlClient.getCaches().getObjectCache(immutableType);
        if (cache != null) {
            ArrayList entities = new ArrayList(cache.getAll(distinctIds, new QueryCacheEnvironment(this.sqlClient, con, null, CacheLoader.objectLoader(this.sqlClient, con, immutableType.getJavaClass()))).values());
            if (fetcher != null && !entities.isEmpty()) {
                boolean needUnload = false;
                block1: for (ImmutableSpi spi : entities) {
                    for (ImmutableProp prop : immutableType.getProps().values()) {
                        if (!spi.__isLoaded(prop.getName()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                        needUnload = true;
                        continue block1;
                    }
                }
                if (needUnload) {
                    ListIterator<ImmutableSpi> itr = entities.listIterator();
                    while (itr.hasNext()) {
                        ImmutableSpi spi;
                        spi = (ImmutableSpi)itr.next();
                        itr.set((ImmutableSpi)Internal.produce((ImmutableType)immutableType, (Object)spi, draft -> {
                            for (ImmutableProp prop : immutableType.getProps().values()) {
                                if (!spi.__isLoaded(prop.getName()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                                ((DraftSpi)draft).__unload(prop.getName());
                            }
                        }));
                    }
                }
                Fetchers.fetch(this.sqlClient, con, Collections.singletonList(new FetcherSelection<E>(){

                    @Override
                    public Fetcher<E> getFetcher() {
                        return fetcher;
                    }
                }), entities);
            }
            return entities;
        }
        return (List)Queries.createQuery(this.sqlClient, immutableType, (q, table) -> {
            Object idProp = table.get(immutableType.getIdProp().getName());
            if (distinctIds.size() == 1) {
                q.where(new Predicate[]{idProp.eq(distinctIds.iterator().next())});
            } else {
                q.where(new Predicate[]{idProp.in(distinctIds)});
            }
            return q.select(table.fetch(fetcher));
        }).execute(con);
    }

    @Override
    public <E> SimpleEntitySaveCommand<E> saveCommand(E entity) {
        if (entity instanceof Collection) {
            throw new IllegalArgumentException("entity cannot be collection, do you want to call 'batchSaveCommand'?");
        }
        return new SimpleEntitySaveCommandImpl<E>(this.sqlClient, entity);
    }

    @Override
    public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> entities) {
        return new BatchEntitySaveCommandImpl<E>(this.sqlClient, entities);
    }

    @Override
    public DeleteCommand deleteCommand(Class<?> entityType, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'batchDeleteCommand'?");
        }
        return this.batchDeleteCommand(entityType, Collections.singleton(id));
    }

    @Override
    public DeleteCommand batchDeleteCommand(Class<?> entityType, Collection<?> ids) {
        ImmutableType immutableType = ImmutableType.get(entityType);
        return new DeleteCommandImpl(this.sqlClient, immutableType, ids);
    }
}

