/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.loader;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ListLoader;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.loader.BatchCommand;
import org.babyfish.jimmer.sql.association.loader.SingleCommand;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.fetcher.Filter;

class ListLoaderImpl<S, T>
implements ListLoader<S, T> {
    private SqlClient sqlClient;
    private ImmutableProp prop;
    private Filter<?> filter;

    public ListLoaderImpl(SqlClient sqlClient, ImmutableProp prop, Filter<?> filter) {
        this.sqlClient = sqlClient;
        this.prop = prop;
        this.filter = filter;
    }

    @Override
    public Executable<List<T>> loadCommand(S source, int limit, int offset) {
        if (source instanceof Collection) {
            throw new IllegalArgumentException("source cannot be collection, do you want to call 'batchLoadCommand'?");
        }
        return new SingleCommand<List<T>>(this.sqlClient, this.prop, this.filter, limit, offset, (ImmutableSpi)source);
    }

    @Override
    public Executable<Map<S, List<T>>> batchLoadCommand(Collection<S> sources) {
        return new BatchCommand(this.sqlClient, this.prop, this.filter, sources);
    }
}

