/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.ListLoader;
import org.babyfish.jimmer.sql.ReferenceLoader;
import org.babyfish.jimmer.sql.SqlClientImpl;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.ConfigurableTypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public interface SqlClient {
    public static Builder newBuilder() {
        return new Builder();
    }

    public ConnectionManager getConnectionManager();

    public Dialect getDialect();

    public Executor getExecutor();

    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> var1);

    public IdGenerator getIdGenerator(Class<?> var1);

    public int getDefaultBatchSize();

    public int getDefaultListBatchSize();

    public <T extends Table<?>, R> ConfigurableTypedRootQuery<T, R> createQuery(Class<T> var1, BiFunction<MutableRootQuery<T>, T, ConfigurableTypedRootQuery<T, R>> var2);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>, R> ConfigurableTypedRootQuery<AssociationTable<SE, ST, TE, TT>, R> createAssociationQuery(Class<ST> var1, Function<ST, TT> var2, BiFunction<MutableRootQuery<AssociationTable<SE, ST, TE, TT>>, AssociationTable<SE, ST, TE, TT>, ConfigurableTypedRootQuery<AssociationTable<SE, ST, TE, TT>, R>> var3);

    public <T extends Table<?>> Executable<Integer> createUpdate(Class<T> var1, BiConsumer<MutableUpdate, T> var2);

    public <T extends Table<?>> Executable<Integer> createDelete(Class<T> var1, BiConsumer<MutableDelete, T> var2);

    public Entities getEntities();

    public <ST extends Table<?>> Associations getAssociations(Class<ST> var1, Function<ST, ? extends Table<?>> var2);

    public Associations getAssociations(Class<?> var1, String var2);

    public Associations getAssociations(ImmutableProp var1);

    public Associations getAssociations(AssociationType var1);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ReferenceLoader<SE, TE> getReferenceLoader(Class<ST> var1, Function<ST, TT> var2);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ReferenceLoader<SE, TE> getReferenceLoader(Class<ST> var1, Function<ST, TT> var2, Filter<TT> var3);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ListLoader<SE, TE> getListLoader(Class<ST> var1, Function<ST, TT> var2);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ListLoader<SE, TE> getListLoader(Class<ST> var1, Function<ST, TT> var2, Filter<TT> var3);

    public Caches getCaches();

    public static class Builder {
        private ConnectionManager connectionManager;
        private Dialect dialect;
        private Executor executor;
        private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private Caches caches;

        Builder() {
        }

        public Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        public Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        public Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        public Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            if (this.scalarProviderMap.containsKey(scalarProvider.getScalarType())) {
                throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarProvider.getScalarType() + "\" twice");
            }
            this.scalarProviderMap.put(scalarProvider.getScalarType(), scalarProvider);
            return this;
        }

        public Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        public Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        public Builder setCaches(Consumer<CacheConfig> block) {
            this.caches = Caches.of(block);
            return this;
        }

        public SqlClient build() {
            return new SqlClientImpl(this.connectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.caches);
        }
    }
}

