/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class ResultMapper {
    private SqlClient sqlClient;
    private List<Selection<?>> selections;
    private ResultSet resultSet;
    private int index;

    public ResultMapper(SqlClient sqlClient, List<Selection<?>> selections, ResultSet resultSet) {
        if (selections.isEmpty() || selections.size() > 9) {
            throw new IllegalArgumentException("selection count must between 1 and 9");
        }
        this.sqlClient = sqlClient;
        this.selections = selections;
        this.resultSet = resultSet;
    }

    public Object map() throws SQLException {
        this.index = 1;
        switch (this.selections.size()) {
            case 1: {
                return this.map(this.selections.get(0));
            }
            case 2: {
                return new Tuple2<Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)));
            }
            case 3: {
                return new Tuple3<Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)));
            }
            case 4: {
                return new Tuple4<Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)));
            }
            case 5: {
                return new Tuple5<Object, Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)), this.map(this.selections.get(4)));
            }
            case 6: {
                return new Tuple6<Object, Object, Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)), this.map(this.selections.get(4)), this.map(this.selections.get(5)));
            }
            case 7: {
                return new Tuple7<Object, Object, Object, Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)), this.map(this.selections.get(4)), this.map(this.selections.get(5)), this.map(this.selections.get(6)));
            }
            case 8: {
                return new Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)), this.map(this.selections.get(4)), this.map(this.selections.get(5)), this.map(this.selections.get(6)), this.map(this.selections.get(7)));
            }
            case 9: {
                return new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(this.map(this.selections.get(0)), this.map(this.selections.get(1)), this.map(this.selections.get(2)), this.map(this.selections.get(3)), this.map(this.selections.get(4)), this.map(this.selections.get(5)), this.map(this.selections.get(6)), this.map(this.selections.get(7)), this.map(this.selections.get(8)));
            }
        }
        throw new AssertionError((Object)"Internal bug: selection count must between 1 and 9");
    }

    private Object map(Selection<?> selection) throws SQLException {
        if (selection instanceof Table) {
            ImmutableType immutableType = TableImplementor.unwrap((Table)selection).getImmutableType();
            if (immutableType instanceof AssociationType) {
                return this.map((AssociationType)immutableType);
            }
            return this.map(immutableType, null);
        }
        if (selection instanceof FetcherSelection) {
            Fetcher fetcher = ((FetcherSelection)selection).getFetcher();
            return this.map(fetcher.getImmutableType(), fetcher);
        }
        return this.read(((ExpressionImplementor)selection).getType());
    }

    private Association<?, ?> map(AssociationType associationType) throws SQLException {
        ImmutableType sourceType = associationType.getSourceType();
        ImmutableType targetType = associationType.getTargetType();
        ImmutableProp sourceIdProp = sourceType.getIdProp();
        ImmutableProp targetIdProp = targetType.getIdProp();
        Object sourceId = this.read(sourceIdProp.getElementClass());
        Object targetId = this.read(targetIdProp.getElementClass());
        Object source = Internal.produce((ImmutableType)sourceType, null, srcDraft -> ((DraftSpi)srcDraft).__set(sourceIdProp.getName(), sourceId));
        Object target = Internal.produce((ImmutableType)targetType, null, tgtDraft -> ((DraftSpi)tgtDraft).__set(targetIdProp.getName(), targetId));
        return new Association<Object, Object>(source, target);
    }

    private Object map(ImmutableType immutableType, Fetcher<?> fetcher) throws SQLException {
        Object id = this.read(immutableType.getIdProp().getElementClass());
        Collection props = fetcher != null ? (Collection)fetcher.getFieldMap().values().stream().map((? super T it) -> it.getProp()).filter(it -> it.getStorage() instanceof Column).collect(Collectors.toList()) : immutableType.getSelectableProps().values();
        if (id == null) {
            this.index += props.size() - 1;
            return null;
        }
        return Internal.produce((ImmutableType)immutableType, null, draft -> {
            DraftSpi spi = (DraftSpi)draft;
            spi.__set(immutableType.getIdProp().getName(), id);
            for (ImmutableProp prop : props) {
                if (prop.isId()) continue;
                ImmutableType targetType = prop.getTargetType();
                if (targetType != null) {
                    Object targetId = this.read(targetType.getIdProp().getElementClass());
                    Object target = targetId != null ? Internal.produce((ImmutableType)targetType, null, targetDraft -> {
                        DraftSpi targetSpi = (DraftSpi)targetDraft;
                        targetSpi.__set(targetType.getIdProp().getName(), targetId);
                    }) : null;
                    spi.__set(prop.getName(), target);
                    continue;
                }
                spi.__set(prop.getName(), this.read(prop.getElementClass()));
            }
        });
    }

    private Object read(Class<?> type) throws SQLException {
        Object sqlValue;
        Class<Object> expectedType;
        Object value = this.resultSet.getObject(this.index++);
        ScalarProvider<?, Object> scalarProvider = this.sqlClient.getScalarProvider(type);
        Class<Object> clazz = expectedType = scalarProvider != null ? scalarProvider.getSqlType() : type;
        if (value == null) {
            sqlValue = null;
        } else {
            sqlValue = Converters.tryConvert(value, expectedType);
            if (sqlValue == null) {
                throw new ExecutionException("Failed the convert the result value at column $" + (this.index - 1) + ", the expected type is '" + type.getName() + "', but the actual type is '" + value.getClass().getName() + "'");
            }
        }
        return scalarProvider != null ? scalarProvider.toScalar(sqlValue) : sqlValue;
    }
}

