/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.sql.cache.CacheChain;
import org.babyfish.jimmer.sql.cache.CacheProvider;

public abstract class AbstractSimpleCacheProvider<V>
implements CacheProvider<V> {
    @Override
    public final Map<String, V> getAll(Set<String> storageKeys, CacheChain<V> chain) {
        Map<String, V> cachedMap = this.read(storageKeys);
        LinkedHashSet<String> missedStorageKeys = new LinkedHashSet<String>();
        for (String storageKey : storageKeys) {
            if (cachedMap.containsKey(storageKey)) continue;
            missedStorageKeys.add(storageKey);
        }
        if (missedStorageKeys.isEmpty()) {
            return cachedMap;
        }
        Map<String, V> moreMap = chain.getAll(missedStorageKeys);
        LinkedHashMap<String, V> writeMap = new LinkedHashMap<String, V>((moreMap.size() * 4 + 2) / 3);
        for (String missedStorageKey : missedStorageKeys) {
            V value = moreMap.get(missedStorageKey);
            if (value == null && !this.isNullSavable()) continue;
            writeMap.put(missedStorageKey, value);
        }
        this.write(writeMap);
        LinkedHashMap<String, V> resultMap = new LinkedHashMap<String, V>(((cachedMap.size() + moreMap.size()) * 4 + 2) / 3);
        for (String storageKey : storageKeys) {
            V value = cachedMap.get(storageKey);
            if (value == null) {
                value = moreMap.get(storageKey);
            }
            if (value == null && !cachedMap.containsKey(storageKey) && !moreMap.containsKey(storageKey)) continue;
            resultMap.put(storageKey, value);
        }
        return resultMap;
    }

    protected abstract Map<String, V> read(Set<String> var1);

    protected abstract void write(Map<String, V> var1);

    protected abstract boolean isNullSavable();
}

