/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.babyfish.jimmer.sql.cache.CacheFilter;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.CacheProvider;
import org.babyfish.jimmer.sql.cache.impl.KeyManager;

class OperationContext<K, V>
extends KeyManager<K, V>
implements AutoCloseable {
    private final CacheLocker locker;
    private final CacheLoader<K, V> loader;
    private final CacheProvider<V>[] providers;
    private NavigableSet<String> lockedStorageKeys;

    OperationContext(String prefix, Collection<K> keys, CacheFilter filter, CacheLoader<K, V> loader, CacheLocker locker, CacheProvider<V>[] providers) {
        super(prefix, keys, filter);
        this.locker = locker;
        this.loader = loader;
        this.providers = providers;
    }

    CacheProvider<V> provider(int index) {
        return this.providers[index];
    }

    int size() {
        return this.providers.length;
    }

    Map<String, V> loadAll(Set<String> storageKeys) {
        if (storageKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.loader != null) {
            TreeSet<String> lockedStorageKeys = new TreeSet<String>(storageKeys);
            this.locker.lockAll(lockedStorageKeys);
            if (this.lockedStorageKeys == null) {
                this.lockedStorageKeys = lockedStorageKeys;
            } else {
                this.lockedStorageKeys.addAll(lockedStorageKeys);
            }
        }
        LinkedHashSet keys = new LinkedHashSet((storageKeys.size() * 4 + 2) / 3);
        for (String cacheKey : storageKeys) {
            keys.add(this.keyMap.get(cacheKey));
        }
        Map<K, V> loadedMap = this.loader.loadAll(keys, this.filter);
        return this.toStorageMap(loadedMap);
    }

    @Override
    public void close() {
        NavigableSet<String> keys = this.lockedStorageKeys;
        if (keys != null) {
            this.lockedStorageKeys = null;
            this.locker.unlockAll(keys);
        }
    }
}

