/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.babyfish.jimmer.sql.cache.CacheFilter;

class KeyManager<K, V> {
    private final String prefix;
    private final String suffix;
    protected final Map<String, K> keyMap;
    protected final Map<K, String> storageKeyMap;
    protected CacheFilter filter;

    public KeyManager(String prefix, Collection<K> keys, CacheFilter filter) {
        NavigableMap<String, Object> args = null;
        if (filter != null) {
            args = filter.toCacheArgs();
        }
        String suffix = args == null || args.isEmpty() ? null : ":" + args.toString();
        LinkedHashMap<String, K> keyMap = new LinkedHashMap<String, K>();
        LinkedHashMap<K, String> storageKeyMap = new LinkedHashMap<K, String>();
        for (K key : keys) {
            String storageKey = key.toString();
            if (prefix != null) {
                storageKey = prefix + storageKey;
            }
            if (suffix != null) {
                storageKey = storageKey + suffix;
            }
            keyMap.put(storageKey, key);
            storageKeyMap.put(key, storageKey);
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.keyMap = Collections.unmodifiableMap(keyMap);
        this.storageKeyMap = Collections.unmodifiableMap(storageKeyMap);
        this.filter = filter;
    }

    Set<K> keys() {
        return this.storageKeyMap.keySet();
    }

    Set<String> storageKeys() {
        return this.keyMap.keySet();
    }

    public Map<K, V> toMap(Map<String, V> map) {
        LinkedHashMap<K, V> resultMap = new LinkedHashMap<K, V>((map.size() + 4 + 2) / 3);
        for (Map.Entry<String, V> e : map.entrySet()) {
            K key = this.keyMap.get(e.getKey());
            V value = e.getValue();
            if (value == null) continue;
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public Map<String, V> toStorageMap(Map<K, V> map) {
        LinkedHashMap<String, V> resultMap = new LinkedHashMap<String, V>((map.size() + 4 + 2) / 3);
        for (Map.Entry<K, V> e : map.entrySet()) {
            String storageKey = this.storageKeyMap.get(e.getKey());
            V value = e.getValue();
            if (value == null) continue;
            resultMap.put(storageKey, value);
        }
        return resultMap;
    }
}

