/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.sql.cache.CacheChain;
import org.babyfish.jimmer.sql.cache.CacheProvider;

public class CompositeProvider<V>
implements CacheProvider<V> {
    private CacheProvider<V>[] providers;

    private CompositeProvider(CacheProvider<V>[] providers) {
        this.providers = providers;
    }

    public static <V> CacheProvider<V> of(Collection<CacheProvider<V>> providers) {
        ArrayList<CacheProvider<V>> list = new ArrayList<CacheProvider<V>>(providers.size());
        for (CacheProvider<V> provider : providers) {
            if (provider instanceof CompositeProvider) {
                CompositeProvider composite = (CompositeProvider)provider;
                list.addAll(Arrays.asList(composite.providers));
                continue;
            }
            if (provider == null) continue;
            list.add(provider);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No provider is specified");
        }
        if (list.size() == 1) {
            return (CacheProvider)list.get(0);
        }
        return new CompositeProvider<V>(list.toArray(new CacheProvider[list.size()]));
    }

    @Override
    public Map<String, V> getAll(Set<String> storageKeys, CacheChain<V> chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAll(Set<String> storageKeys) {
        throw new UnsupportedOperationException();
    }

    CacheProvider<V>[] providers() {
        return this.providers;
    }
}

