/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheFilter;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.CacheProvider;
import org.babyfish.jimmer.sql.cache.impl.CacheChainImpl;
import org.babyfish.jimmer.sql.cache.impl.CompositeProvider;
import org.babyfish.jimmer.sql.cache.impl.KeyManager;
import org.babyfish.jimmer.sql.cache.impl.OperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl<K, V>
implements Cache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheImpl.class);
    private final String keyPrefix;
    private final CacheProvider<V>[] providers;
    private final CacheLoader<K, V> loader;
    private final CacheLocker locker;

    public CacheImpl(String keyPrefix, CacheProvider<V> provider, CacheLoader<K, V> loader, CacheLocker locker) {
        Objects.requireNonNull(keyPrefix, "keyPrefix cannot be null");
        Objects.requireNonNull(provider, "provider cannot be null");
        Objects.requireNonNull(loader, "loader cannot be null");
        this.keyPrefix = keyPrefix;
        this.providers = provider instanceof CompositeProvider ? ((CompositeProvider)provider).providers() : new CacheProvider[]{provider};
        this.loader = loader;
        this.locker = locker;
    }

    @Override
    public final V get(K key, CacheFilter filter) {
        return this.getAll(Collections.singleton(key), filter).get(key);
    }

    @Override
    public final Map<K, V> getAll(Collection<K> keys, CacheFilter filter) {
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        try (OperationContext<K, V> ctx = new OperationContext<K, V>(this.keyPrefix, keys, filter, this.loader, this.locker, this.providers);){
            Map<String, V> map = this.providers[0].getAll(ctx.storageKeys(), new CacheChainImpl<V>(ctx, 1));
            Map map2 = ctx.toMap(map);
            return map2;
        }
    }

    @Override
    public void delete(K key, CacheFilter filter) {
        this.deleteAll(Collections.singleton(key), filter);
    }

    @Override
    public void deleteAll(Collection<K> keys, CacheFilter filter) {
        if (!keys.isEmpty()) {
            KeyManager keyManager = new KeyManager(this.keyPrefix, keys, filter);
            Throwable throwable = null;
            for (CacheProvider<V> provider : this.providers) {
                try {
                    provider.deleteAll(keyManager.storageKeys());
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }
}

