/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.tuple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Tuple2<T1, T2> {
    private final T1 _1;
    private final T2 _2;

    public Tuple2(T1 _1, T2 _2) {
        this._1 = _1;
        this._2 = _2;
    }

    public T1 _1() {
        return this._1;
    }

    public T2 _2() {
        return this._2;
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple2 other = (Tuple2)o;
        return Objects.equals(this._1, other._1) && Objects.equals(this._2, other._2);
    }

    public String toString() {
        return "Tuple2{_1=" + this._1 + ", _2=" + this._2 + '}';
    }

    public static <K, V> Map<K, V> toMap(Collection<Tuple2<K, V>> tuples) {
        LinkedHashMap map = new LinkedHashMap((tuples.size() * 4 + 2) / 3);
        for (Tuple2<K, V> tuple : tuples) {
            map.put(tuple._1, tuple._2);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toMultiMap(Collection<Tuple2<K, V>> tuples) {
        LinkedHashMap<Object, List> map = new LinkedHashMap<Object, List>();
        for (Tuple2<K, V> tuple : tuples) {
            map.computeIfAbsent(tuple._1, it -> new ArrayList()).add(tuple._2);
        }
        return map;
    }
}

