/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.HashMap;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Key;

class ImmutableCache {
    private AbstractEntitySaveCommandImpl.Data data;
    private Map<Object, ImmutableSpi> idObjMap = new HashMap<Object, ImmutableSpi>();
    private Map<Key, ImmutableSpi> keyObjMap = new HashMap<Key, ImmutableSpi>();

    public ImmutableCache(AbstractEntitySaveCommandImpl.Data data) {
        this.data = data;
    }

    public ImmutableSpi find(ImmutableSpi example) {
        Object id;
        ImmutableType type = example.__type();
        ImmutableProp idProp = type.getIdProp();
        if (example.__isLoaded(idProp.getName()) && (id = example.__get(idProp.getName())) != null) {
            return this.idObjMap.get(id);
        }
        Key key = Key.of(this.data, example, true);
        return this.keyObjMap.get(key);
    }

    public void save(ImmutableSpi spi) {
        this.save(spi, false);
    }

    public void save(ImmutableSpi spi, boolean insertOnly) {
        ImmutableSpi oldSpi;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        if (!insertOnly && (oldSpi = this.find(spi)) != null) {
            Object oldId = oldSpi.__get(idProp.getName());
            this.idObjMap.remove(oldId);
            Key oldKey = Key.of(this.data, oldSpi, false);
            if (oldKey != null) {
                this.keyObjMap.remove(oldKey);
            }
            ImmutableSpi newSpi = spi;
            spi = (ImmutableSpi)Internal.produce((ImmutableType)spi.__type(), (Object)oldSpi, draft -> {
                for (ImmutableProp prop : type.getProps().values()) {
                    if (!newSpi.__isLoaded(prop.getName())) continue;
                    ((DraftSpi)draft).__set(prop.getName(), newSpi.__get(prop.getName()));
                }
            });
        }
        Object id = spi.__get(idProp.getName());
        this.idObjMap.put(id, spi);
        Key key = Key.of(this.data, spi, false);
        if (key != null) {
            this.keyObjMap.put(key, spi);
        }
    }
}

