/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.ImmutableCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;

class BatchEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl<BatchEntitySaveCommand<E>>
implements BatchEntitySaveCommand<E> {
    private Collection<E> entities;

    BatchEntitySaveCommandImpl(SqlClient sqlClient, Collection<E> entities) {
        super(sqlClient, null);
        for (E entity : entities) {
            if (entity instanceof ImmutableSpi) continue;
            throw new IllegalArgumentException("All the elements of entities must be an immutable object");
        }
        this.entities = entities;
    }

    private BatchEntitySaveCommandImpl(BatchEntitySaveCommandImpl<E> base, AbstractEntitySaveCommandImpl.Data data) {
        super(base.sqlClient, data);
        this.entities = base.entities;
    }

    @Override
    public BatchSaveResult<E> execute() {
        return this.sqlClient.getConnectionManager().execute((Connection connection) -> this.execute((Connection)connection));
    }

    @Override
    public BatchSaveResult<E> execute(Connection con) {
        ImmutableCache cache = new ImmutableCache(this.data);
        LinkedHashMap<AffectedTable, Integer> affectedRowCountMap = new LinkedHashMap<AffectedTable, Integer>();
        List simpleSaveResults = this.entities.stream().map(it -> new Saver(this.data, con, cache, affectedRowCountMap).save(it)).collect(Collectors.toList());
        return new BatchSaveResult(affectedRowCountMap, simpleSaveResults);
    }

    @Override
    BatchEntitySaveCommand<E> create(AbstractEntitySaveCommandImpl.Data data) {
        return new BatchEntitySaveCommandImpl<E>(this, data);
    }
}

