/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.loader;

import java.util.Collection;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ReferenceLoader;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.loader.BatchCommand;
import org.babyfish.jimmer.sql.association.loader.SingleCommand;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.fetcher.Filter;

class ReferenceLoaderImpl<S, T>
implements ReferenceLoader<S, T> {
    private SqlClient sqlClient;
    private ImmutableProp prop;
    private Filter<?> filter;

    public ReferenceLoaderImpl(SqlClient sqlClient, ImmutableProp prop, Filter<?> filter) {
        this.sqlClient = sqlClient;
        this.prop = prop;
        this.filter = filter;
    }

    @Override
    public Executable<T> loadCommand(S source) {
        if (source instanceof Collection) {
            throw new IllegalArgumentException("source cannot be collection, do you want to call 'batchLoadCommand'?");
        }
        return new SingleCommand(this.sqlClient, this.prop, this.filter, Integer.MAX_VALUE, 0, (ImmutableSpi)source);
    }

    @Override
    public Executable<Map<S, T>> batchLoadCommand(Collection<S> sources) {
        return new BatchCommand(this.sqlClient, this.prop, this.filter, sources);
    }
}

