/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.loader;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.association.loader.BatchDataLoader;
import org.babyfish.jimmer.sql.association.loader.Keys;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.meta.Column;

class BatchCommand<S, T>
implements Executable<Map<S, T>> {
    private SqlClient sqlClient;
    private ImmutableProp prop;
    private Filter<Table<ImmutableSpi>> filter;
    private Collection<ImmutableSpi> sources;

    public BatchCommand(SqlClient sqlClient, ImmutableProp prop, Filter<Table<ImmutableSpi>> filter, Collection<ImmutableSpi> sources) {
        this.sqlClient = sqlClient;
        this.prop = prop;
        this.filter = filter;
        this.sources = sources;
    }

    @Override
    public Map<S, T> execute() {
        return this.sqlClient.getConnectionManager().execute((Connection connection) -> this.execute((Connection)connection));
    }

    @Override
    public Map<S, T> execute(Connection con) {
        Map<ImmutableSpi, Object> map = Keys.keyMap(this.prop, this.sources);
        Map<Object, ?> targetMap = new BatchDataLoader(this.sqlClient, con, this.prop, this.filter).load(this.prop.getStorage() instanceof Column ? new LinkedHashSet<Object>(map.values()) : map.values());
        Iterator<Map.Entry<ImmutableSpi, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ImmutableSpi, Object> e;
            Object value = targetMap.get((e = iterator.next()).getValue());
            e.setValue(value == null && this.prop.isEntityList() ? Collections.emptyList() : value);
        }
        return map;
    }
}

