/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.sql.runtime.ExecutionException;

@FunctionalInterface
public interface ConnectionManager {
    public <R> R execute(Function<Connection, R> var1);

    public static ConnectionManager simpleConnectionManager(final DataSource dataSource) {
        return new ConnectionManager(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public <R> R execute(Function<Connection, R> block) {
                try (Connection con = dataSource.getConnection();){
                    R r = block.apply(con);
                    return r;
                }
                catch (Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new ExecutionException(ex.getMessage(), ex);
                }
            }
        };
    }
}

