/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.FilterArgs;

public interface Filter<E, T extends Table<E>> {
    public void apply(FilterArgs<E, T> var1);

    public static <E, T extends Table<E>> Filter<E, T> sortingFilter(Class<T> tableType, Function<T, PropExpression<?>> block) {
        return Filter.sortingFilter(tableType, block, OrderMode.ASC, NullOrderMode.UNSPECIFIED);
    }

    public static <E, T extends Table<E>> Filter<E, T> sortingFilter(Class<T> tableType, Function<T, PropExpression<?>> block, OrderMode orderMode) {
        return Filter.sortingFilter(tableType, block, orderMode, NullOrderMode.UNSPECIFIED);
    }

    public static <E, T extends Table<E>> Filter<E, T> sortingFilter(Class<T> tableType, Function<T, PropExpression<?>> block, OrderMode orderMode, NullOrderMode nullOrderMode) {
        return Filter.sortingFilterBuilder(tableType).add(block, orderMode, nullOrderMode).build();
    }

    public static <E, T extends Table<E>> SortingFilterBuilder<E, T> sortingFilterBuilder(Class<T> tableType) {
        return new SortingFilterBuilder(tableType);
    }

    public static class SortingFilterBuilder<E, T extends Table<E>> {
        private Class<T> tableType;
        private List<SortedField> sortedFields = new ArrayList<SortedField>();

        public SortingFilterBuilder(Class<T> tableType) {
            this.tableType = tableType;
        }

        public SortingFilterBuilder<E, T> add(Function<T, PropExpression<?>> block) {
            return this.add(block, OrderMode.ASC, NullOrderMode.UNSPECIFIED);
        }

        public SortingFilterBuilder<E, T> add(Function<T, PropExpression<?>> block, OrderMode orderMode) {
            return this.add(block, orderMode, NullOrderMode.UNSPECIFIED);
        }

        public SortingFilterBuilder<E, T> add(Function<T, PropExpression<?>> block, OrderMode orderMode, NullOrderMode nullOrderMode) {
            ImmutableProp prop = ImmutableProps.get(this.tableType, block);
            SortedField sortedField = new SortedField(prop.getName(), Objects.requireNonNull(orderMode, "orderMode cannot be null"), Objects.requireNonNull(nullOrderMode, "nullOrderMode cannot be null"));
            this.sortedFields.add(sortedField);
            return this;
        }

        public Filter<E, T> build() {
            return new FilterImpl(this.sortedFields);
        }

        private static class SortedField {
            final String prop;
            final OrderMode orderMode;
            final NullOrderMode nullOrderMode;

            public SortedField(String prop, OrderMode orderMode, NullOrderMode nullOrderMode) {
                this.prop = prop;
                this.orderMode = orderMode;
                this.nullOrderMode = nullOrderMode;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.prop, this.orderMode, this.nullOrderMode});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SortedField that = (SortedField)o;
                return this.prop.equals(that.prop) && this.orderMode == that.orderMode && this.nullOrderMode == that.nullOrderMode;
            }

            public String toString() {
                return "SortedField{prop=" + this.prop + ", orderMode=" + (Object)((Object)this.orderMode) + ", nullOrderMode=" + (Object)((Object)this.nullOrderMode) + '}';
            }
        }

        private static class FilterImpl<E, T extends Table<E>>
        implements Filter<E, T> {
            private List<SortedField> sortedFields;

            public FilterImpl(List<SortedField> sortedFields) {
                this.sortedFields = sortedFields;
            }

            @Override
            public void apply(FilterArgs<E, T> args) {
                for (SortedField sortedField : this.sortedFields) {
                    args.orderBy((Expression<?>)args.getTable().get(sortedField.prop), sortedField.orderMode, sortedField.nullOrderMode);
                }
            }

            public int hashCode() {
                return Objects.hash(this.sortedFields);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FilterImpl filter = (FilterImpl)o;
                return this.sortedFields.equals(filter.sortedFields);
            }

            public String toString() {
                return "FilterImpl{sortedFields=" + this.sortedFields + '}';
            }
        }
    }
}

