/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DeleteAction;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class Deleter {
    private DeleteCommandImpl.Data data;
    private Connection con;
    private Map<AffectedTable, Integer> affectedRowCountMap;
    private Map<ImmutableType, Set<Object>> preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private Map<ImmutableType, Set<Object>> postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private Map<String, Deleter> childDeleterMap = new LinkedHashMap<String, Deleter>();

    Deleter(DeleteCommandImpl.Data data, Connection con) {
        this(data, con, new LinkedHashMap<AffectedTable, Integer>());
    }

    Deleter(DeleteCommandImpl.Data data, Connection con, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.con = con;
        this.affectedRowCountMap = affectedRowCountMap;
    }

    public void addPreHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.preHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addPostHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.postHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
    }

    public DeleteResult execute() {
        while (!this.preHandleIdInputMap.isEmpty() || !this.postHandleIdInputMap.isEmpty()) {
            while (!this.preHandleIdInputMap.isEmpty()) {
                this.preHandle();
            }
            this.postHandle();
        }
        return new DeleteResult(this.affectedRowCountMap);
    }

    private void preHandle() {
        Map<ImmutableType, Set<Object>> idMultiMap = this.preHandleIdInputMap;
        this.preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            this.preHandle(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void preHandle(ImmutableType immutableType, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        for (ImmutableProp prop : immutableType.getProps().values()) {
            ImmutableProp mappedByProp = prop.getMappedBy();
            ImmutableProp middleTableProp = null;
            MiddleTable middleTable = null;
            if (mappedByProp != null) {
                if (mappedByProp.getStorage() instanceof MiddleTable) {
                    middleTableProp = mappedByProp;
                    middleTable = ((MiddleTable)middleTableProp.getStorage()).getInverse();
                }
            } else if (prop.getStorage() instanceof MiddleTable) {
                middleTableProp = prop;
                middleTable = (MiddleTable)middleTableProp.getStorage();
            }
            if (middleTable != null) {
                this.deleteFromMiddleTable(middleTableProp, middleTable, ids);
            }
            if (!prop.isEntityList() || mappedByProp == null || !mappedByProp.isReference()) continue;
            DeleteAction deleteAction = this.data.getDeleteAction(mappedByProp);
            if (deleteAction == DeleteAction.SET_NULL) {
                this.updateChildTable(mappedByProp, ids);
                continue;
            }
            this.tryDeleteFromChildTable(prop, ids);
        }
        this.addPostHandleInput(immutableType, ids);
    }

    private void deleteFromMiddleTable(ImmutableProp middleTableProp, MiddleTable middleTable, Collection<Object> ids) {
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("delete from ");
        builder.sql(middleTable.getTableName());
        builder.sql(" where ");
        builder.sql(middleTable.getJoinColumnName());
        builder.sql(" in(");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.middle(middleTableProp), affectedRowCount);
    }

    private void updateChildTable(ImmutableProp manyToOneProp, Collection<Object> ids) {
        ImmutableType childType = manyToOneProp.getDeclaringType();
        String fkColumnName = ((Column)manyToOneProp.getStorage()).getName();
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("update ").sql(childType.getTableName()).sql(" set ").sql(fkColumnName).sql(" = null where ").sql(fkColumnName).sql(" in(");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.of(childType), affectedRowCount);
    }

    private void tryDeleteFromChildTable(ImmutableProp prop, Collection<?> ids) {
        ImmutableProp manyToOneProp = prop.getMappedBy();
        ImmutableType childType = manyToOneProp.getDeclaringType();
        String fkColumnName = ((Column)manyToOneProp.getStorage()).getName();
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("select ").sql(((Column)childType.getIdProp().getStorage()).getName()).sql(" from ").sql(childType.getTableName()).sql(" where ").sql(fkColumnName).sql(" in(");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        List childIds = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), stmt -> {
            ArrayList<Object> values = new ArrayList<Object>();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    values.add(rs.getObject(1));
                }
            }
            return values;
        });
        if (!childIds.isEmpty()) {
            if (this.data.getDeleteAction(manyToOneProp) != DeleteAction.CASCADE) {
                throw new ExecutionException("Cannot delete entities whose type are \"" + manyToOneProp.getTargetType().getJavaClass().getName() + "\" because there are some child entities whose type are \"" + manyToOneProp.getDeclaringType().getJavaClass().getName() + "\", these child entities use the association property \"" + manyToOneProp + "\" to reference current entities.");
            }
            Deleter childDeleter = this.childDeleterMap.computeIfAbsent(prop.getName(), it -> new Deleter(this.data, this.con, this.affectedRowCountMap));
            childDeleter.addPreHandleInput(childType, childIds);
            childDeleter.preHandle();
        }
    }

    private void postHandle() {
        this.childDeleterMap.values().forEach(Deleter::postHandle);
        Map<ImmutableType, Set<Object>> idMultiMap = this.postHandleIdInputMap;
        this.postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            this.deleteFromSelfTable(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void deleteFromSelfTable(ImmutableType type, Collection<Object> ids) {
        String fkColumnName = ((Column)type.getIdProp().getStorage()).getName();
        SqlBuilder builder = new SqlBuilder(this.data.getSqlClient());
        builder.sql("delete from ");
        builder.sql(type.getTableName());
        builder.sql(" where ");
        builder.sql(fkColumnName);
        builder.sql(" in(");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult._1(), sqlResult._2(), PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.of(type), affectedRowCount);
    }
}

