/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NumberExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class SimpleCaseBuilder<C, T> {
    private Class<T> type;
    private Expression<?> expression;
    private List<Tuple2<Expression<?>, Expression<T>>> whens = new ArrayList();

    SimpleCaseBuilder(Class<T> type, Expression<?> expression) {
        this.type = type;
        this.expression = expression;
    }

    public SimpleCaseBuilder<C, T> when(C cond, T then) {
        return this.when(Literals.any(cond), Literals.any(then));
    }

    public SimpleCaseBuilder<C, T> when(Expression<C> cond, T then) {
        return this.when(cond, Literals.any(then));
    }

    public SimpleCaseBuilder<C, T> when(C cond, Expression<T> then) {
        return this.when(Literals.any(cond), then);
    }

    public SimpleCaseBuilder<C, T> when(Expression<C> cond, Expression<T> then) {
        this.whens.add(new Tuple2<Expression<C>, Expression<T>>(cond, then));
        return this;
    }

    public Expression<T> otherwise(T otherwise) {
        return this.otherwise(Literals.any(otherwise));
    }

    public Expression<T> otherwise(Expression<T> otherwise) {
        ArrayList whens = new ArrayList(this.whens);
        if (String.class.isAssignableFrom(this.type)) {
            return new StrExpr(this.expression, whens, otherwise);
        }
        if (this.type.isPrimitive() || Number.class.isAssignableFrom(this.type)) {
            return new NumExpr<String>((Class<String>)this.type, this.expression, whens, otherwise);
        }
        if (Comparable.class.isAssignableFrom(this.type)) {
            return new CmpExpr<String>(this.type, this.expression, whens, otherwise);
        }
        return new AnyExpr<String>(this.type, this.expression, whens, otherwise);
    }

    private static class StrExpr
    extends AnyExpr<String>
    implements StringExpressionImplementor {
        StrExpr(Expression<?> expression, List<Tuple2<Expression<?>, Expression<String>>> whens, Expression<String> otherwise) {
            super(String.class, expression, whens, otherwise);
        }
    }

    private static class NumExpr<N extends Number>
    extends AnyExpr<N>
    implements NumberExpressionImplementor<N> {
        NumExpr(Class<N> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<N>>> whens, Expression<N> otherwise) {
            super(type, expression, whens, otherwise);
        }
    }

    private static class CmpExpr<T extends Comparable<T>>
    extends AnyExpr<T>
    implements ComparableExpressionImplementor<T> {
        CmpExpr(Class<T> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<T>>> whens, Expression<T> otherwise) {
            super(type, expression, whens, otherwise);
        }
    }

    private static class AnyExpr<T>
    extends AbstractExpression<T> {
        private Class<T> type;
        private Expression<?> expression;
        private List<Tuple2<Expression<?>, Expression<T>>> whens;
        private Expression<T> otherwise;

        AnyExpr(Class<T> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<T>>> whens, Expression<T> otherwise) {
            this.type = type;
            this.expression = expression;
            this.whens = whens;
            this.otherwise = otherwise;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public int precedence() {
            return 0;
        }

        @Override
        public void accept(AstVisitor visitor) {
            ((Ast)((Object)this.expression)).accept(visitor);
            for (Tuple2<Expression<?>, Expression<T>> when : this.whens) {
                ((Ast)((Object)when._1())).accept(visitor);
                ((Ast)((Object)when._2())).accept(visitor);
            }
            ((Ast)((Object)this.otherwise)).accept(visitor);
        }

        @Override
        public void renderTo(SqlBuilder builder) {
            this.usingLowestPrecedence(() -> {
                builder.sql("case ");
                this.renderChild((Ast)((Object)this.expression), builder);
                for (Tuple2<Expression<?>, Expression<T>> when : this.whens) {
                    builder.sql(" when ");
                    this.renderChild((Ast)((Object)when._1()), builder);
                    builder.sql(" then ");
                    this.renderChild((Ast)((Object)when._2()), builder);
                }
                builder.sql(" else ");
                this.renderChild((Ast)((Object)this.otherwise), builder);
                builder.sql(" end");
            });
        }
    }

    public static class Cmp<C, T extends Comparable<T>>
    extends SimpleCaseBuilder<C, T> {
        Cmp(Class<T> type, Expression<?> expression) {
            super(type, expression);
        }

        @Override
        public Cmp<C, T> when(C cond, T then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(Expression<C> cond, T then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(C cond, Expression<T> then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(Expression<C> cond, Expression<T> then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public ComparableExpression<T> otherwise(T otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }

        @Override
        public ComparableExpression<T> otherwise(Expression<T> otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }
    }

    public static class Num<C, N extends Number>
    extends SimpleCaseBuilder<C, N> {
        Num(Class<N> type, Expression<?> expression) {
            super(type, expression);
        }

        @Override
        public Num<C, N> when(C cond, N then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(Expression<C> cond, N then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(C cond, Expression<N> then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(Expression<C> cond, Expression<N> then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public NumericExpression<N> otherwise(N otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }

        @Override
        public NumericExpression<N> otherwise(Expression<N> otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }
    }

    public static class Str<C>
    extends SimpleCaseBuilder<C, String> {
        Str(Expression<?> expression) {
            super(String.class, expression);
        }

        public Str<C> when(C cond, String then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(Expression<C> cond, String then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(C cond, Expression<String> then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(Expression<C> cond, Expression<String> then) {
            return (Str)super.when(cond, then);
        }

        public StringExpression otherwise(String otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }

        public StringExpression otherwise(Expression<String> otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }
    }
}

