/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.Filter;
import org.babyfish.jimmer.sql.fetcher.impl.Ids;
import org.babyfish.jimmer.sql.meta.Column;

public class DataCache {
    private static final Object NULL = new Object();
    private Map<FieldKey, Map<Object, Object>> map = new HashMap<FieldKey, Map<Object, Object>>();

    public Object createKey(Field field, ImmutableSpi owner) {
        ImmutableProp prop = field.getProp();
        if (prop.getStorage() instanceof Column) {
            return Ids.idOf((ImmutableSpi)owner.__get(prop.getName()));
        }
        return Ids.idOf(owner);
    }

    public Object get(Field field, Object key) {
        Map<Object, Object> subMap = this.map.get(new FieldKey(field));
        if (subMap == null) {
            return null;
        }
        return subMap.get(key);
    }

    public void put(Field field, Object key, Object value) {
        Map subMap = this.map.computeIfAbsent(new FieldKey(field), it -> new HashMap());
        subMap.put(key, value != null ? value : NULL);
    }

    public static Object unwrap(Object value) {
        return value == NULL ? null : value;
    }

    private static class FieldKey {
        private ImmutableProp prop;
        private Filter<?, ?> filter;
        private int limit;
        private int offset;

        FieldKey(Field field) {
            this(field.getProp(), field.getFilter(), field.getLimit(), field.getOffset());
        }

        FieldKey(ImmutableProp prop, Filter<?, ?> filter, int limit, int offset) {
            this.prop = prop;
            this.filter = filter;
            this.limit = limit;
            this.offset = offset;
        }

        public int hashCode() {
            return Objects.hash(this.prop, this.filter, this.limit, this.offset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return this.limit == fieldKey.limit && this.offset == fieldKey.offset && this.prop.equals(fieldKey.prop) && Objects.equals(this.filter, fieldKey.filter);
        }

        public String toString() {
            return "FieldKey{prop=" + this.prop + ", filter=" + this.filter + ", limit=" + this.limit + ", offset=" + this.offset + '}';
        }
    }
}

