/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTableWrapper;
import org.babyfish.jimmer.util.StaticCache;

public class TableExWrappers {
    private static final StaticCache<Class<?>, Constructor<?>> CACHE = new StaticCache(TableExWrappers::createConstructor);

    private TableExWrappers() {
    }

    public static <T extends TableEx<?>> T wrap(TableImplementor<?> table) {
        if (table.getImmutableType() instanceof AssociationType || table instanceof AbstractTableWrapper) {
            return (T)table;
        }
        Class javaClass = table.getImmutableType().getJavaClass();
        Constructor constructor = (Constructor)CACHE.get((Object)javaClass);
        if (constructor == null) {
            throw new IllegalStateException("No TableEx wrapper class for \"" + table.getImmutableType() + "\"");
        }
        try {
            return (T)((TableEx)constructor.newInstance(table));
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new AssertionError((Object)("Internal bug: Can not create instance of " + constructor.getDeclaringClass().getName()));
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new AssertionError((Object)("Internal bug: Can not create instance of " + constructor.getDeclaringClass().getName()));
        }
    }

    private static Constructor<?> createConstructor(Class<?> javaClass) {
        Class<?> tableClass;
        try {
            tableClass = Class.forName(javaClass.getName() + "TableEx");
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        if (!AbstractTableWrapper.class.isAssignableFrom(tableClass)) {
            return null;
        }
        try {
            return tableClass.getConstructor(TableEx.class);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

