/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.SqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.BatchEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SimpleEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.Converters;

public class EntitiesImpl
implements Entities {
    private SqlClient sqlClient;

    public EntitiesImpl(SqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    @Override
    public <E> E findById(Class<E> entityType, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(entityType, null, Collections.singleton(id));
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    @Override
    public <E> List<E> findByIds(Class<E> entityType, Collection<Object> ids) {
        return this.findByIds(entityType, null, ids);
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Class<E> entityType, Collection<ID> ids) {
        String idPropName = ImmutableType.get(entityType).getIdProp().getName();
        return this.findByIds(entityType, null, ids).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idPropName), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    @Override
    public <E> E findById(Fetcher<E> fetcher, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(fetcher.getJavaClass(), fetcher, Collections.singleton(id));
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    @Override
    public <E> List<E> findByIds(Fetcher<E> fetcher, Collection<Object> ids) {
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids);
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Collection<ID> ids) {
        String idPropName = ImmutableType.get(fetcher.getJavaClass()).getIdProp().getName();
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idPropName), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    private <E> List<E> findByIds(Class<E> entityType, Fetcher<E> fetcher, Collection<?> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableType immutableType = ImmutableType.get(entityType);
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : ids) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        return (List)Queries.createQuery(this.sqlClient, immutableType, (q, table) -> {
            Object idProp = table.get(immutableType.getIdProp().getName());
            if (ids.size() == 1) {
                q.where(new Predicate[]{idProp.eq(ids.iterator().next())});
            } else {
                q.where(new Predicate[]{idProp.in(ids)});
            }
            return q.select(table.fetch(fetcher));
        }).execute();
    }

    @Override
    public <E> SimpleEntitySaveCommand<E> saveCommand(E entity) {
        if (entity instanceof Collection) {
            throw new IllegalArgumentException("entity cannot be collection, do you want to call 'batchSaveCommand'?");
        }
        return new SimpleEntitySaveCommandImpl<E>(this.sqlClient, entity);
    }

    @Override
    public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> entities) {
        return new BatchEntitySaveCommandImpl<E>(this.sqlClient, entities);
    }

    @Override
    public DeleteCommand deleteCommand(Class<?> entityType, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'batchDeleteCommand'?");
        }
        return this.batchDeleteCommand(entityType, Collections.singleton(id));
    }

    @Override
    public DeleteCommand batchDeleteCommand(Class<?> entityType, Collection<?> ids) {
        ImmutableType immutableType = ImmutableType.get(entityType);
        return new DeleteCommandImpl(this.sqlClient, immutableType, ids);
    }
}

