/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.kt.filter.impl;

import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import org.babyfish.jimmer.kt.ImmutableObjectsKt;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.filter.BuiltInFilters;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.kt.filter.KBuiltInFilters;
import org.babyfish.jimmer.sql.kt.filter.KFilter;
import org.babyfish.jimmer.sql.kt.filter.KFilters;
import org.babyfish.jimmer.sql.kt.filter.impl.KBuiltInFiltersImpl;
import org.babyfish.jimmer.sql.kt.filter.impl.KtFiltersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u0011\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013\u0018\u00010\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J6\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0018\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013\u0018\u00010\u00122\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/babyfish/jimmer/sql/kt/filter/impl/KFiltersImpl;", "Lorg/babyfish/jimmer/sql/kt/filter/KFilters;", "javaFilters", "Lorg/babyfish/jimmer/sql/filter/Filters;", "(Lorg/babyfish/jimmer/sql/filter/Filters;)V", "builtIns", "Lorg/babyfish/jimmer/sql/kt/filter/KBuiltInFilters;", "getBuiltIns", "()Lorg/babyfish/jimmer/sql/kt/filter/KBuiltInFilters;", "getFilter", "Lorg/babyfish/jimmer/sql/kt/filter/KFilter;", "T", "", "type", "Lkotlin/reflect/KClass;", "shardingOnly", "", "getParameterMapRef", "Lorg/babyfish/jimmer/lang/Ref;", "Ljava/util/SortedMap;", "", "getTargetFilter", "prop", "Lkotlin/reflect/KProperty1;", "getTargetParameterMapRef", "jimmer-sql-kotlin"})
public final class KFiltersImpl
implements KFilters {
    @NotNull
    private final Filters javaFilters;
    @NotNull
    private final KBuiltInFilters builtIns;

    public KFiltersImpl(@NotNull Filters javaFilters) {
        Intrinsics.checkNotNullParameter((Object)javaFilters, (String)"javaFilters");
        this.javaFilters = javaFilters;
        BuiltInFilters builtInFilters = this.javaFilters.builtIns();
        Intrinsics.checkNotNullExpressionValue((Object)builtInFilters, (String)"javaFilters.builtIns()");
        this.builtIns = new KBuiltInFiltersImpl(builtInFilters);
    }

    @Override
    @Nullable
    public <T> KFilter<T> getFilter(@NotNull KClass<T> type, boolean shardingOnly) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Filter filter = this.javaFilters.getFilter(JvmClassMappingKt.getJavaClass(type), shardingOnly);
        return filter != null ? KtFiltersKt.toKtFilter((Filter<Props>)filter) : null;
    }

    @Override
    @Nullable
    public <T> KFilter<T> getTargetFilter(@NotNull KProperty1<?, ? extends T> prop, boolean shardingOnly) {
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        Filter filter = this.javaFilters.getTargetFilter(ImmutableObjectsKt.toImmutableProp(prop), shardingOnly);
        return filter != null ? KtFiltersKt.toKtFilter((Filter<Props>)filter) : null;
    }

    @Override
    @Nullable
    public Ref<SortedMap<String, Object>> getParameterMapRef(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.javaFilters.getParameterMapRef(JvmClassMappingKt.getJavaClass(type));
    }

    @Override
    @Nullable
    public Ref<SortedMap<String, Object>> getTargetParameterMapRef(@NotNull KProperty1<?, ?> prop) {
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        return this.javaFilters.getTargetParameterMapRef(ImmutableObjectsKt.toImmutableProp(prop));
    }

    @Override
    @NotNull
    public KBuiltInFilters getBuiltIns() {
        return this.builtIns;
    }
}

