/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.kt.ast.expression.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.babyfish.jimmer.sql.kt.ast.expression.KExpression;
import org.babyfish.jimmer.sql.kt.ast.expression.impl.ExpressionPlaceholder;
import org.babyfish.jimmer.sql.kt.ast.expression.impl.ValuePlaceholder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\u00020\f\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0010J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011J\u001d\u0010\u0012\u001a\u00020\f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0012\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/babyfish/jimmer/sql/kt/ast/expression/impl/SqlDSL;", "", "sql", "", "(Ljava/lang/String;)V", "expressionPlaceholder", "Lorg/babyfish/jimmer/sql/kt/ast/expression/impl/ExpressionPlaceholder;", "parts", "", "valuePlaceholder", "Lorg/babyfish/jimmer/sql/kt/ast/expression/impl/ValuePlaceholder;", "addExpressionPlaceholder", "", "addValuePlaceholder", "expression", "T", "Lorg/babyfish/jimmer/sql/kt/ast/expression/KExpression;", "", "value", "(Ljava/lang/Object;)V", "jimmer-sql-kotlin"})
public final class SqlDSL {
    @NotNull
    private final List<Object> parts;
    @Nullable
    private ExpressionPlaceholder expressionPlaceholder;
    @Nullable
    private ValuePlaceholder valuePlaceholder;

    public SqlDSL(@NotNull String sql) {
        int index;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.parts = new ArrayList();
        int startIndex = 0;
        while ((index = StringsKt.indexOf$default((CharSequence)sql, (char)'%', (int)startIndex, (boolean)false, (int)4, null)) != -1) {
            int n;
            if (index + 1 >= sql.length()) continue;
            Collection collection = this.parts;
            String string = sql.substring(startIndex, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(string);
            char c = sql.charAt(index + 1);
            if (c == 'e') {
                this.addExpressionPlaceholder();
                n = 2;
            } else if (c == 'v') {
                this.addValuePlaceholder();
                n = 2;
            } else {
                n = 1;
            }
            startIndex = index + n;
        }
        if (startIndex < sql.length()) {
            Collection collection = this.parts;
            String string = sql.substring(startIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(string);
        }
    }

    public final <T> void expression(@NotNull KExpression<T> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        ExpressionPlaceholder head = this.expressionPlaceholder;
        if (head == null) {
            throw new IllegalStateException("Too many expressions");
        }
        head.setExpression(expression);
        this.expressionPlaceholder = head.getNext();
    }

    public final <T> void value(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        ValuePlaceholder head = this.valuePlaceholder;
        if (head == null) {
            throw new IllegalStateException("Too many values");
        }
        head.setValue(value);
        this.valuePlaceholder = head.getNext();
    }

    private final void addExpressionPlaceholder() {
        ExpressionPlaceholder it = new ExpressionPlaceholder();
        boolean bl = false;
        ((Collection)this.parts).add(it);
        ExpressionPlaceholder head = this.expressionPlaceholder;
        if (head != null) {
            head.setNext(it);
        } else {
            this.expressionPlaceholder = it;
        }
    }

    private final void addValuePlaceholder() {
        ValuePlaceholder it = new ValuePlaceholder();
        boolean bl = false;
        ((Collection)this.parts).add(it);
        ValuePlaceholder head = this.valuePlaceholder;
        if (head != null) {
            head.setNext(it);
        } else {
            this.valuePlaceholder = it;
        }
    }

    @NotNull
    public final List<Object> parts() {
        if (this.expressionPlaceholder != null) {
            throw new IllegalStateException("Not all the expression placeholders are resolved");
        }
        if (this.valuePlaceholder != null) {
            throw new IllegalStateException("Not all the value placeholders are resolved");
        }
        return this.parts;
    }
}

