/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.graphql;

import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;

public class DataFetchingEnvironments {
    private DataFetchingEnvironments() {
    }

    public static <T> Fetcher<T> createFetcher(Class<T> rootType, DataFetchingEnvironment env) {
        Context ctx = new Context(env, rootType);
        ctx.add(env.getMergedField().getSingleField().getSelectionSet());
        return ctx.fetcher;
    }

    private static class Context {
        private final DataFetchingEnvironment env;
        private final Class<?> type;
        private FetcherImplementor<?> fetcher;

        Context(DataFetchingEnvironment env, Class<?> type) {
            this.env = env;
            this.type = type;
        }

        public void add(SelectionSet selectionSet) {
            if (selectionSet == null) {
                return;
            }
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    this.add((Field)selection);
                    continue;
                }
                if (selection instanceof FragmentSpread) {
                    this.add((FragmentSpread)selection);
                    continue;
                }
                if (!(selection instanceof InlineFragment)) continue;
                this.add((InlineFragment)selection);
            }
        }

        private void add(Field field) {
            ImmutableProp prop;
            if (!field.getArguments().isEmpty()) {
                return;
            }
            if (this.fetcher == null) {
                this.fetcher = new FetcherImpl(this.type);
            }
            FetcherImplementor<?> childFetcher = null;
            if (field.getSelectionSet() != null && (prop = (ImmutableProp)this.fetcher.getImmutableType().getProps().get(field.getName())) != null) {
                Context subContext = new Context(this.env, prop.getTargetType().getJavaClass());
                subContext.add(field.getSelectionSet());
                childFetcher = subContext.fetcher;
            }
            this.fetcher = this.fetcher.add(field.getName(), childFetcher);
        }

        private void add(FragmentSpread fragmentSpread) {
            FragmentDefinition definition = (FragmentDefinition)this.env.getFragmentsByName().get(fragmentSpread.getName());
            if (definition == null) {
                return;
            }
            if (this.isValidFragmentOwner(definition.getTypeCondition())) {
                this.add(definition.getSelectionSet());
            }
        }

        private void add(InlineFragment inlineFragment) {
            if (this.isValidFragmentOwner(inlineFragment.getTypeCondition())) {
                this.add(inlineFragment.getSelectionSet());
            }
        }

        private boolean isValidFragmentOwner(TypeName fragmentOwner) {
            GraphQLType graphQLType = this.env.getGraphQLSchema().getType(fragmentOwner.getName());
            if (!(graphQLType instanceof GraphQLObjectType)) {
                return false;
            }
            return Context.isValidSimpleName(((GraphQLObjectType)graphQLType).getName(), this.type);
        }

        private static boolean isValidSimpleName(String simpleName, Class<?> t) {
            if (t.getSimpleName().equals(simpleName)) {
                return true;
            }
            for (Class<?> itf : t.getInterfaces()) {
                if (!Context.isValidSimpleName(simpleName, itf)) continue;
                return true;
            }
            return false;
        }
    }
}

