/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Path;
import org.babyfish.jimmer.spring.repository.parser.PathParser;
import org.babyfish.jimmer.spring.repository.parser.PropPredicate;
import org.babyfish.jimmer.spring.repository.parser.Source;
import org.babyfish.jimmer.sql.ast.LikeMode;

class PropPredicateParser {
    private final Context ctx;
    private final boolean allowCollection;
    private final boolean allIgnoreCase;
    private Path path;
    private PropPredicate.Op op = PropPredicate.Op.EQ;
    private boolean ignoreCase;
    private LikeMode likeMode = LikeMode.EXACT;

    PropPredicateParser(Context ctx, boolean allowCollection, boolean allIgnoreCase) {
        this.ctx = ctx;
        this.allowCollection = allowCollection;
        this.allIgnoreCase = allIgnoreCase;
    }

    PropPredicate parse(Source source, ImmutableType type) {
        source = this.parseIgnoreCase(source);
        source = this.parseOp(source);
        Path path = new PathParser(this.ctx, this.allowCollection).parse(source, type);
        return new PropPredicate.Unresolved(path, this.op, this.ignoreCase, this.likeMode);
    }

    private Source parseIgnoreCase(Source source) {
        Source restSource = source.trimEnd("IgnoringCase", "IgnoreCase");
        if (restSource != null && this.allIgnoreCase) {
            throw new IllegalArgumentException("The predicate \"" + source + "\" cannot be ignore case when \"AllIgnoreCase\" is already set");
        }
        this.ignoreCase = this.allIgnoreCase || restSource != null;
        return restSource != null ? restSource : source;
    }

    private Source parseOp(Source source) {
        Source restSource = source.trimEnd("IsTrue", "True");
        if (restSource != null) {
            this.op = PropPredicate.Op.TRUE;
            return restSource;
        }
        restSource = source.trimEnd("IsFalse", "False");
        if (restSource != null) {
            this.op = PropPredicate.Op.FALSE;
            return restSource;
        }
        restSource = source.trimEnd("Is", "Equals");
        if (restSource != null) {
            this.op = PropPredicate.Op.EQ;
            return restSource;
        }
        restSource = source.trimEnd("IsNot", "Not");
        if (restSource != null) {
            this.op = PropPredicate.Op.NE;
            return restSource;
        }
        restSource = source.trimEnd("IsLessThan", "LessThan");
        if (restSource != null) {
            this.op = PropPredicate.Op.LT;
            return restSource;
        }
        restSource = source.trimEnd("IsLessThanEqual", "LessThanEqual");
        if (restSource != null) {
            this.op = PropPredicate.Op.LE;
            return restSource;
        }
        restSource = source.trimEnd("IsGreaterThan", "GreaterThan");
        if (restSource != null) {
            this.op = PropPredicate.Op.GT;
            return restSource;
        }
        restSource = source.trimEnd("IsGreaterThanEqual", "GreaterThanEqual");
        if (restSource != null) {
            this.op = PropPredicate.Op.GE;
            return restSource;
        }
        restSource = source.trimEnd("IsBefore", "Before");
        if (restSource != null) {
            this.op = PropPredicate.Op.LT;
            return restSource;
        }
        restSource = source.trimEnd("IsAfter", "After");
        if (restSource != null) {
            this.op = PropPredicate.Op.GT;
            return restSource;
        }
        restSource = source.trimEnd("IsNotBetween", "NotBetween");
        if (restSource != null) {
            this.op = PropPredicate.Op.NOT_BETWEEN;
            return restSource;
        }
        restSource = source.trimEnd("IsBetween", "Between");
        if (restSource != null) {
            this.op = PropPredicate.Op.BETWEEN;
            return restSource;
        }
        restSource = source.trimEnd("IsNotLike", "NotLike");
        if (restSource != null) {
            this.op = PropPredicate.Op.NOT_LIKE;
            this.likeMode = LikeMode.ANYWHERE;
            return restSource;
        }
        restSource = source.trimEnd("IsLike", "Like");
        if (restSource != null) {
            this.op = PropPredicate.Op.LIKE;
            this.likeMode = LikeMode.ANYWHERE;
            return restSource;
        }
        restSource = source.trimEnd("IsContaining", "Containing", "Contains");
        if (restSource != null) {
            this.op = PropPredicate.Op.LIKE;
            this.likeMode = LikeMode.ANYWHERE;
            return restSource;
        }
        restSource = source.trimEnd("IsStartingWith", "StartingWith", "StartsWith");
        if (restSource != null) {
            this.op = PropPredicate.Op.LIKE;
            this.likeMode = LikeMode.START;
            return restSource;
        }
        restSource = source.trimEnd("IsEndingWith", "EndingWith", "EndsWith");
        if (restSource != null) {
            this.op = PropPredicate.Op.LIKE;
            this.likeMode = LikeMode.END;
            return restSource;
        }
        restSource = source.trimEnd("IsNotIn", "NotIn");
        if (restSource != null) {
            this.op = PropPredicate.Op.NOT_IN;
            return restSource;
        }
        restSource = source.trimEnd("IsIn", "In");
        if (restSource != null) {
            this.op = PropPredicate.Op.IN;
            return restSource;
        }
        restSource = source.trimEnd("IsNotNull", "NotNull");
        if (restSource != null) {
            this.op = PropPredicate.Op.NOT_NULL;
            return restSource;
        }
        restSource = source.trimEnd("IsNull", "Null");
        if (restSource != null) {
            this.op = PropPredicate.Op.NULL;
            return restSource;
        }
        this.op = PropPredicate.Op.EQ;
        return source;
    }
}

