/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.babyfish.jimmer.spring.cfg.HttpServletCondition;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.cfg.MicroServiceCondition;
import org.babyfish.jimmer.spring.client.JavaFeignController;
import org.babyfish.jimmer.spring.client.OpenApiController;
import org.babyfish.jimmer.spring.client.OpenApiUiController;
import org.babyfish.jimmer.spring.client.TypeScriptController;
import org.babyfish.jimmer.spring.cloud.MicroServiceExporterController;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@Conditional(value={HttpServletCondition.class})
public class ServletControllerConfiguration {
    @ConditionalOnProperty(value={"jimmer.client.ts.path"})
    @ConditionalOnMissingBean(value={TypeScriptController.class})
    @Bean
    public TypeScriptController typeScriptController(JimmerProperties properties) {
        return new TypeScriptController(properties);
    }

    @ConditionalOnProperty(value={"jimmer.client.openapi.path"})
    @ConditionalOnMissingBean(value={OpenApiController.class})
    @Bean
    public OpenApiController openApiController(JimmerProperties properties) {
        return new OpenApiController(properties);
    }

    @ConditionalOnProperty(value={"jimmer.client.openapi.ui-path"})
    @ConditionalOnMissingBean(value={OpenApiUiController.class})
    @Bean
    public OpenApiUiController openApiUiController(JimmerProperties properties) {
        return new OpenApiUiController(properties);
    }

    @ConditionalOnProperty(value={"jimmer.client.java-feign.path"})
    @ConditionalOnMissingBean(value={JavaFeignController.class})
    @Bean
    public JavaFeignController javaFeignController(JimmerProperties properties) {
        return new JavaFeignController(properties);
    }

    @Conditional(value={MicroServiceCondition.class})
    @ConditionalOnMissingBean(value={MicroServiceExporterController.class})
    @Bean
    public MicroServiceExporterController microServiceExporterController(@Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient, ObjectMapper objectMapper) {
        return new MicroServiceExporterController((JSqlClient)(jSqlClient != null ? jSqlClient : kSqlClient.getJavaClient()), objectMapper);
    }
}

